package com.gogirl.domain.product.serve;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created by yinyong on 2018/8/20.
 */
@ApiModel("服务")
@Data
@TableName("base_serve")
public class BaseServe implements Serializable {

    @TableId
    private Integer id;

    @ApiModelProperty("服务名称")
    private String name;

    @ApiModelProperty("图片名称")
    private String picturePath;

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("标签")
    private String label;

    @ApiModelProperty("服务价格")
    private BigDecimal price;

    @ApiModelProperty("排序")
    private Integer shopSort;

    @ApiModelProperty("状态 0：下架 1：上架 4：删除',")
    private Integer status;

    private String remark;

    @ApiModelProperty("详情")
    private String details;

    @ApiModelProperty("服务时长")
    private Integer serviceDuration;

    @ApiModelProperty("是否首页显示 1-是 ")
    private Integer hasIndexShow;

    @ApiModelProperty("首页排序")
    private Integer indexSort;

    @TableField(exist = false)
    @ApiModelProperty("//用户查询列表时，查用户是否点赞")
    private Integer cusId;

    @ApiModelProperty("用户点赞总数")
    private Integer praiseSum;

    @ApiModelProperty("服务简介")
    private String briefIntroduction;

    @ApiModelProperty("类型id")
    private Integer typeId;

    @ApiModelProperty("预约分类")
    private Integer schTypeId;

    @ApiModelProperty("是否可跳色 1-是 2-否 ")
    private Integer isColorJump;

    @TableField(value = "`explain`")
    private String explain;

    @TableField(exist = false)
    private Integer labelId;

    /**
     * 非数据库字段
     */
    @TableField(exist = false)
    private BigDecimal discountRate;

    @TableField(exist = false)
    @ApiModelProperty("款式")
    private String produces;

    @ApiModelProperty("款式列表")
    @TableField(exist = false)
    private List<BaseProduce> listProduce;

    @TableField(exist = false)
    private List<Label> listLabel;

    @ApiModelProperty("款式")
    @TableField(exist = false)
    private BaseProduce produce;

    @ApiModelProperty("点赞记录")
    @TableField(exist = false)
    private PraiseRecord praiseRecord;

    @ApiModelProperty("是否自带款式 1-是 2-否")
    private Integer isOwnProduce;

}
