package com.gogirl.application.user.customer.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.user.customer.IBeautyExpoQuestionnaireService;
import com.gogirl.domain.user.customer.BeautyExpoQuestionnaire;
import com.gogirl.infrastructure.common.exception.ErrorCode;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.mapper.user.customer.BeautyExpoQuestionnaireMapper;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-24
 */
@Service
public class BeautyExpoQuestionnaireServiceImpl extends ServiceImpl<BeautyExpoQuestionnaireMapper, BeautyExpoQuestionnaire> implements IBeautyExpoQuestionnaireService {

    @Override
    public BeautyExpoQuestionnaire submitQuestionnaire(BeautyExpoQuestionnaire beautyExpoQuestionnaire) {
        if (hasSubmitted(beautyExpoQuestionnaire.getCustomerId(), beautyExpoQuestionnaire.getType())) {
            throw new RRException(ErrorCode.CS_2003);
        }
        this.save(beautyExpoQuestionnaire);
        return beautyExpoQuestionnaire;
    }

    @Override
    public Boolean hasSubmitted(Integer customerId, Integer type) {
        BeautyExpoQuestionnaire questionnaire = this.getOne(new LambdaQueryWrapper<BeautyExpoQuestionnaire>()
                .eq(BeautyExpoQuestionnaire::getCustomerId, customerId)
                .eq(BeautyExpoQuestionnaire::getType, type));
        return questionnaire != null;
    }

    @Override
    public Integer submittedQuestionnaire(Integer customerId, Integer type) {
        BeautyExpoQuestionnaire questionnaire = this.getOne(new LambdaQueryWrapper<BeautyExpoQuestionnaire>()
                .eq(BeautyExpoQuestionnaire::getCustomerId, customerId)
                .eq(BeautyExpoQuestionnaire::getType, type));

        return questionnaire == null ? 0 : questionnaire.getId();
    }
}
