package com.gogirl.application.store.store;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.domain.store.career.Career;
import com.gogirl.domain.store.career.CareerWorks;
import com.gogirl.shared.store.SubmitWorksCommand;
import com.gogirl.shared.store.WorksQuery;

public interface CareerCmdService {
    /**
     * 提交美甲作品
     *
     * @param cmd
     */
    void submitWorks(SubmitWorksCommand cmd);



    /**
     * 美甲作品
     *
     * @param qry
     * @return
     */
    IPage<CareerWorks> queryWorks(WorksQuery qry);



    /**
     * 查询
     *
     * @param technicianId
     * @return
     */
    Career career(Integer technicianId);

    /**
     * 获取需要打板的款式
     *
     * @param technicianId
     * @param pageNum
     * @param pageSize
     * @return
     */
    Page<BaseProduce> queryWorkTpl(Integer technicianId, Integer pageNum, Integer pageSize, String searchKeyWord);


}
