package com.gogirl.interfaces.user;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gogirl.application.market.CouponCustomerRelevanceService;
import com.gogirl.application.market.CouponService;
import com.gogirl.application.market.MarketService;
import com.gogirl.domain.market.coupon.CouponCustomerRelevance;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.infrastructure.util.SessionUtils;
import com.gogirl.shared.market.command.SetTimesCardCommand;
import com.gogirl.shared.market.command.SetUpInnerCouponCommand;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

@RestController
@AllArgsConstructor
@Slf4j
@Api(tags = {"优惠券接口"}, value = "优惠券接口")
public class CouponCustomerRelevanceController {

    private final CouponService couponService;
    private final CouponCustomerRelevanceService couponCustomerRelevanceService;

    @ApiOperation(value = "用户根据订单号查询可用优惠券")
    @GetMapping("/customer/getOrderCoupon")
    public JsonResult<List<CouponCustomerRelevance>> getOrderCoupon(@RequestHeader String token,
                                                                    @RequestParam Integer orderId) {

        Integer currentCustomerId = SessionUtils.getCustomerToken().getCustomerId();
        List<CouponCustomerRelevance> list = couponCustomerRelevanceService.getOrderCoupon(currentCustomerId, orderId);
        return JsonResult.success(list);
    }

    @ApiOperation(value = "我的优惠券列表")
    @GetMapping("/customer/getMyCoupon")
    public JsonResult<IPage<CouponCustomerRelevance>> getMyCoupon(String token,
                                                                  Integer pageNum,
                                                                  Integer pageSize,
                                                                  Integer state,
                                                                  Boolean containRemoveCoupon) {
        Integer customerId = SessionUtils.getCustomerId();
        log.info("查询领取优惠券的用户列表CouponCustomerRelevance:" + customerId.toString());
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 20;
        }
        IPage<CouponCustomerRelevance> pageInfo = couponCustomerRelevanceService.selectMyCoupon(customerId, pageNum, pageSize, state, containRemoveCoupon);
        return JsonResult.success(pageInfo);
    }

    @ApiOperation(value = "美甲师提交外部券")
    @PostMapping("/technician/techSubmitCoupons")
    public JsonResult<Void> techSubmitCoupons(@RequestHeader String token,
                                              @RequestParam Integer orderId,
                                              @RequestParam String couponIds) {
        GogirlToken gogirlToken = SessionUtils.getTechnicianToken();
        log.info("美甲师 {} 提交外部券,couponId", gogirlToken.getTechnicianId());

        List<Integer> idList = StringUtils.isNotEmpty(couponIds) ? Lists.newArrayList(couponIds.split(",")).stream().map(Integer::valueOf).collect(Collectors.toList()) : Lists.newArrayList();
        couponCustomerRelevanceService.techSubmitCoupons(orderId, idList);
        return JsonResult.success();
    }


    private final MarketService marketService;


    @Transactional
    @ApiOperation(value = "用户提交优惠券")
    @PostMapping(value = "/customer/submitCoupons")
    public JsonResult<Void> submitCoupons(@RequestParam Integer orderId,
                                          @RequestParam String couponRelevanceIds,
                                          @RequestParam String timesCardIds) {

        log.info("用户提交优惠券 orderId:{},couponIds:{}", orderId, couponRelevanceIds);

        List<Integer> innerCouponIds = StringUtils.isNotEmpty(couponRelevanceIds)
                ? Lists.newArrayList(couponRelevanceIds.split(",")).stream().map(Integer::valueOf).collect(Collectors.toList())
                : Lists.newArrayList();

        marketService.setUpInnerCoupon(SetUpInnerCouponCommand.builder()
                .innerCouponCustomerRelevanceIds(innerCouponIds)
                .orderId(orderId)
                .build());

        List<Integer> timesCardCustomerIds = StringUtils.isNotEmpty(timesCardIds)
                ? Lists.newArrayList(timesCardIds.split(",")).stream().map(Integer::valueOf).collect(Collectors.toList())
                : Lists.newArrayList();

        marketService.setTimesCard(SetTimesCardCommand.builder()
                .orderId(orderId)
                .timesCardIds(timesCardCustomerIds)
                .build());

        marketService.setterOrder(orderId);
        return JsonResult.success();
    }

}
