package com.gogirl.application.product.serve.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.serve.BaseFeaturesService;
import com.gogirl.domain.product.serve.BaseFeatures;
import com.gogirl.infrastructure.mapper.product.serve.BaseFeaturesMapper;
import com.gogirl.shared.product.query.dto.ProduceFeaturesDTO;
import com.gogirl.shared.product.query.dto.ServeFeaturesDTO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
@AllArgsConstructor
@Slf4j
public class BaseFeaturesServiceImpl extends ServiceImpl<BaseFeaturesMapper, BaseFeatures> implements BaseFeaturesService {
    private final BaseFeaturesMapper baseFeaturesMapper;

    @Override
    public List<ServeFeaturesDTO> queryServeFeatures(Integer typeId) {
        List<ServeFeaturesDTO> list = baseFeaturesMapper.queryServeFeatures(typeId)
                .stream()
                .map(baseFeatures -> {
                    ServeFeaturesDTO serveFeaturesDTO = new ServeFeaturesDTO();
                    serveFeaturesDTO.setId(baseFeatures.getId());
                    serveFeaturesDTO.setLabelEnName(baseFeatures.getEnName());
                    serveFeaturesDTO.setLabelName(baseFeatures.getName());
                    serveFeaturesDTO.setPicturePath(baseFeatures.getPicturePath());
                    return serveFeaturesDTO;
                })
                .collect(Collectors.toList());
        return list;
    }

    @Override
    public List<ProduceFeaturesDTO> queryProduceFeatures(Integer serveTypeId) {
        List<ProduceFeaturesDTO> list = baseFeaturesMapper.queryProduceFeatures(serveTypeId)
                .stream()
                .map(baseFeatures -> {
                    ProduceFeaturesDTO produceLabelDTO = new ProduceFeaturesDTO();
                    produceLabelDTO.setId(baseFeatures.getId());
                    produceLabelDTO.setLabelEnName(baseFeatures.getEnName());
                    produceLabelDTO.setLabelName(baseFeatures.getName());
                    produceLabelDTO.setPicturePath(baseFeatures.getPicturePath());
                    return produceLabelDTO;
                })
                .collect(Collectors.toList());
        return list;
    }
}
