package com.gogirl.interfaces.common;

import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.service.file.FileService;
import com.gogirl.infrastructure.util.Base64Utils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;

@RestController
@Api(tags = "文件服务接口")
@Slf4j
public class FileController {

    @Resource
    FileService fileService;

    @ApiOperation(value = "图片上传")
    @PostMapping("/customer/xcx/upload")
    public JsonResult<String> upload(MultipartFile file) throws Exception {
        if (file == null) {
            throw new RRException("上传内容为空");

        }
        log.info("图片上传");
        String imgUrl = fileService.saveImage(file);
        return JsonResult.success(imgUrl);
    }

    @ApiOperation(value = "base64图片上传")
    @PostMapping("/customer/xcx/no_base64Upload")
    public JsonResult<String> base64Upload(@RequestBody String base64) throws Exception {
        if (base64 == null) {
            throw new RRException("上传内容为空");
        }
        log.info("图片上传");
        MultipartFile multipartFile = Base64Utils.base64ToMultipart(base64);
        String imgUrl = fileService.saveImage(multipartFile);
        return JsonResult.success(imgUrl);
    }

}
