package com.gogirl.shared.market;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class TimesCardUsedRecordDTO {

    private Integer id;

    @ApiModelProperty("次卡种类id")
    private Integer cardTypeId;

    @ApiModelProperty("次卡名字")
    private String name;

    @ApiModelProperty("使用顾客id")
    private Integer customerId;

    @ApiModelProperty("次卡id")
    private Integer cardRelevanceCustomerId;

    @ApiModelProperty("生成记录时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date time;

    @ApiModelProperty("1.购卡记录;2;用卡记录")
    private Integer type;

    @ApiModelProperty("订单id")
    private Integer orderId;

    @ApiModelProperty("1.已选择次卡,待付款;2.已使用;3.已取消选择")
    private Integer status;

}
