package com.gogirl.application.order.market.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.order.market.ICouponOrderService;
import com.gogirl.domain.market.coupon.CouponCustomerRelevance;
import com.gogirl.domain.order.market.CouponOrder;
import com.gogirl.infrastructure.mapper.order.market.CouponOrderMapper;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-03-08
 */
@Service
public class CouponOrderServiceImpl extends ServiceImpl<CouponOrderMapper, CouponOrder> implements ICouponOrderService {

    @Override
    public void createOrder(List<CouponCustomerRelevance> couponCustomerRelevanceList) {
        List<CouponOrder> couponOrderList = couponCustomerRelevanceList.stream()
                .map(couponCustomerRelevance ->
                        CouponOrder.builder()
                                .couponOrderNo(IdWorker.getIdStr())
                                .couponCustomerRelevanceId(couponCustomerRelevance.getId())
                                .couponName(couponCustomerRelevance.getCouponName())
                                .createTime(LocalDateTime.now())
                                .customerId(couponCustomerRelevance.getCustomerId())
                                .discountAmount(couponCustomerRelevance.getDiscountAmount())
                                .discountPercent(couponCustomerRelevance.getDiscountPercent())
                                .payAmount(couponCustomerRelevance.getPayAmount())
                                .reachingAmount(couponCustomerRelevance.getReachingAmount())
                                .status(1)
                                .build()
                )
                //只写入支付金额大于0的卡券订单
                .filter(var -> var.getPayAmount().compareTo(BigDecimal.ZERO) > 0)
                .collect(Collectors.toList());
        this.saveBatch(couponOrderList);
    }
}
