package com.gogirl.application.product.serve.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.serve.BaseServeService;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.domain.product.serve.ServiceStorePrice;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.infrastructure.mapper.product.serve.BaseServeMapper;
import com.gogirl.infrastructure.mapper.product.serve.ServiceStorePriceMapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@AllArgsConstructor
public class BaseServeServiceImpl extends ServiceImpl<BaseServeMapper, BaseServe> implements BaseServeService {

    private final BaseServeMapper baseServeMapper;
    private final ServiceStorePriceMapper serviceStorePriceMapper;

    @Override
    public IPage<BaseServe> listServeForPage(IPage<BaseServe> page, BaseServe param) {
        Integer departmentId = SessionUtils.getDepartmentId();
        param.setDepartmentId(departmentId);

        IPage<BaseServe> result = baseServeMapper.listServeForPage(page, param);
        List<Integer> serveIdList = result.getRecords().stream().map(BaseServe::getId).collect(Collectors.toList());


        List<ServiceStorePrice> serviceStorePriceList = serviceStorePriceMapper.selectList(new LambdaQueryWrapper<ServiceStorePrice>()
                .eq(ServiceStorePrice::getStoreId, departmentId)
                .in(ServiceStorePrice::getServiceId, serveIdList));

        Map<Integer, ServiceStorePrice> map = serviceStorePriceList.stream()
                .collect(Collectors.toMap(ServiceStorePrice::getServiceId, serviceStorePrice -> serviceStorePrice));

        result.getRecords().forEach(baseServe -> {
            ServiceStorePrice serviceStorePrice = map.get(baseServe.getId());
            if (serviceStorePrice != null) {
                baseServe.setPrice(serviceStorePrice.getPrice());
            }
        });
        return result;
    }


    @Override
    public BaseServe getAggregate(Integer id) {
        BaseServe baseServe = baseServeMapper.selectById(id);
        Integer departmentId = SessionUtils.getDepartmentId();

        ServiceStorePrice serviceStorePrice = serviceStorePriceMapper.selectOne(new LambdaQueryWrapper<ServiceStorePrice>()
                .eq(ServiceStorePrice::getStoreId, departmentId)
                .eq(ServiceStorePrice::getServiceId, id));

        if (serviceStorePrice != null) {
            baseServe.setPrice(serviceStorePrice.getPrice());
        }
        return baseServe;
    }
}
