package com.gogirl.application.market.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.market.TimesCardService;
import com.gogirl.domain.market.timescard.TimesCardType;
import com.gogirl.domain.market.timescard.TimesCardTypeContent;
import com.gogirl.infrastructure.mapper.market.timescard.TimesCardTypeContentMapper;
import com.gogirl.infrastructure.mapper.market.timescard.TimesCardTypeMapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
@Slf4j
public class TimesCardServiceImpl extends ServiceImpl<TimesCardTypeMapper, TimesCardType> implements TimesCardService {

    private final TimesCardTypeContentMapper timesCardTypeContentMapper;
    private final TimesCardTypeMapper timesCardTypeMapper;

    public List<TimesCardType> getTimesCardTypeList() {

        return timesCardTypeMapper.selectList(new LambdaQueryWrapper<TimesCardType>()
                .eq(TimesCardType::getStatus, TimesCardType.STATUS_ON));
    }

    public TimesCardType getAggregate(Integer id) {
        TimesCardType timesCardType = this.getById(id);
        List<TimesCardTypeContent> timesCardTypeContentList = timesCardTypeContentMapper.selectList(
                new LambdaQueryWrapper<TimesCardTypeContent>().eq(TimesCardTypeContent::getCardTypeId, id)
        );
        return timesCardTypeMapper.selectAggregate(id);
    }

    @Override
    public TimesCardType getTimesCardTypeDetail(Integer id) {
        return timesCardTypeMapper.selectAggregate(id);
    }


}
