package com.gogirl.infrastructure.mapper.order.serve;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gogirl.domain.order.serve.OrderManage;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;

/**
 * Created by yinyong on 2018/9/21.
 */

@Repository
public interface OrderManageMapper extends BaseMapper<OrderManage> {


    /**
     * 获取用户在店铺的总消费
     *
     * @param customerId
     * @param departmentId
     * @return
     */
    BigDecimal countSumPay(@Param("customerId") Integer customerId, @Param("departmentId") Integer departmentId);


    /**
     * 用户预约订单总数
     *
     * @param customerId
     * @return
     */
    Integer countOrderTimes(Integer customerId);

    /**
     * 获取今天最近的一个订单
     *
     * @return order
     */
    OrderManage latestOfDay();


    /**
     * 获取用户当天第一个订单
     *
     * @param customerId
     * @param createTime
     * @return
     */
    OrderManage firstOrderOfDay(@Param("customerId") Integer customerId, @Param("createTime") String createTime);
}
