package com.gogirl.infrastructure.common.config.property;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.domain.common.xcx.GogirlConfig;
import com.gogirl.infrastructure.mapper.common.xcx.GogirlConfigMapper;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.util.List;

@Component
@Data
@Slf4j
//@ConfigurationProperties(prefix = "gogirl")
public class GogirlProperties {

    /**
     * 订单微信支付回调接口
     */
    private String notifyOrder;

    /**
     * 会员充值微信支付回调接口
     */
    private String notifyCharge;

    /**
     * 代理充值回调接口
     */
    private String notifyChargeAgent;

    /**
     * 次卡购买微信支付回调接口
     */
    private String notifyTimesCard;

    /**
     * 商城订单回调
     */
    private String notifyMallOrder;

    /**
     * 图片临时地址
     */
    private String picturePath;


    /**
     * 商城退款回调
     */
    private String notifyRefundMallOrder;

    /**
     *
     */
    private String notifyBalanceWxPay;

    private String startTime;

    private String endTime;

    /**
     * 发送评价是假
     */
    private long testPaperTime;

    /**
     * 后台地址
     */
    private String adminBackendUrl;

    private String adminBackendAchievementsUrl;

    private String enterpriseWechatWebhook;

    @Resource
    private GogirlConfigMapper gogirlConfigMapper;

    @PostConstruct
    public void init(){
        List<GogirlConfig> gogirlConfigList = gogirlConfigMapper.selectList(new LambdaQueryWrapper<GogirlConfig>()
                .eq(GogirlConfig::getType, this.getClass().getSimpleName()));
        Field[] fields = this.getClass().getDeclaredFields();
        for (Field field : fields) {
            try {
                GogirlConfig gogirlConfig = gogirlConfigList.stream().filter(x -> x.getName().equals(field.getName())).findAny().orElseGet(null);
                if(null != gogirlConfig){
                    try {
                        if(field.getName().equals("testPaperTime")){
                            field.setLong(this,Long.parseLong(gogirlConfig.getValue()));
                        }
                        else{
                            field.set(this,gogirlConfig.getValue());
                        }

                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e){
                continue;
            }
        }
    }

}
