package com.gogirl.application.product.mall.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.mall.MallProductService;
import com.gogirl.domain.product.mall.MallProduct;
import com.gogirl.infrastructure.mapper.product.mall.MallProductMapper;
import com.gogirl.shared.product.query.qry.ProductQuery;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service
@AllArgsConstructor
@Slf4j
public class MallProductServiceImpl extends ServiceImpl<MallProductMapper, MallProduct> implements MallProductService {

    private final MallProductMapper mallProductMapper;

    @Override
    public IPage<MallProduct> queryPageProduct(ProductQuery qry) {
        //        return mallProductControllerFeign.queryPageProduct(qry);

        IPage<MallProduct> productIPage = new Page<>();
        return mallProductMapper.queryPageProduct(productIPage, qry);
    }
}
