package com.gogirl.application.product.serve;


import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.product.serve.BaseProduce;

import java.util.List;

/**
 * Created by yinyong on 2018/8/23.
 * 服务款式 服务接口
 */
public interface BaseProduceService extends IService<BaseProduce> {

    /**
     * 查询款式详情
     *
     * @param id 款式id
     * @return 款式详情
     */
    BaseProduce getProduceForDetail(Integer id);


    /**
     * 根据款式id更新款式
     *
     * @param param
     */
    void updateProduceById(BaseProduce param);

    /**
     * 查询首页新品服务款式
     *
     * @param customerId     当前登陆用户id 作为点赞表的连接查询条件，可以为空
     * @param produceLabelId 款式特性id {@link com.gogirl.domain.product.features.BaseFeatures}
     * @return 款式列表
     */
    List<BaseProduce> queryNewServePage(Integer customerId, Integer produceLabelId);
}
