package com.gogirl.interfaces.product.serve;

import com.gogirl.application.product.serve.BaseTypeService;
import com.gogirl.domain.product.serve.BaseType;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@AllArgsConstructor
@Api(tags = {"服务分类接口"})
public class TypeController {

    /**
     * domain service
     */
    private final BaseTypeService baseTypeService;


    @ApiOperation("用户端询服务类型")
    @GetMapping("/customer/type/queryType")
    public JsonResult<List<BaseType>> queryType() {
        return JsonResult.success(baseTypeService.list());
    }


    @ApiOperation("美甲师端查询服务类型")
    @GetMapping("/technician/type/queryType")
    public JsonResult<List<BaseType>> technicianQueryType() {
        return JsonResult.success(baseTypeService.list());
    }
}
