package com.gogirl.infrastructure.service.sms.impl;

import com.github.qcloudsms.SmsSingleSender;
import com.github.qcloudsms.SmsSingleSenderResult;
import com.gogirl.infrastructure.service.sms.SmsService;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONException;
import org.springframework.stereotype.Service;

import javax.xml.ws.http.HTTPException;
import java.io.IOException;

/**
 * 短信服务 腾讯云短信实现
 */
@Service
@Slf4j
public class QCloudSmsServiceImpl implements SmsService {


    @Override
    public SmsSingleSenderResult sendBindSmsCode(String phoneNumber, String code) {
        //
        String smsSign = SmsConstant.smsSign;
        int templateId = SmsConstant.bindTemplateId;
        String[] params = {code, SmsConstant.activeTime};

        SmsSingleSenderResult result = new SmsSingleSenderResult();

        try {
            SmsSingleSender sender = new SmsSingleSender(SmsConstant.appid, SmsConstant.appkey);
            result = sender.sendWithParam("86", phoneNumber, templateId, params, smsSign, "", "");
        }
        // HTTP响应码错误 json解析错误 网络IO错误
        catch (HTTPException | JSONException | IOException | com.github.qcloudsms.httpclient.HTTPException e) {
            log.error(e.getMessage(), e);
        }
        return result;
    }

}
