package com.gogirl.application.store.store;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.domain.store.career.Career;
import com.gogirl.domain.store.career.Works;
import com.gogirl.domain.store.training.TrainingStartClass;
import com.gogirl.shared.store.*;

public interface CareerCmdService {
    /**
     * 提交美甲作品
     *
     * @param cmd
     */
    void submitWorks(SubmitWorksCommand cmd);

    /**
     * 报名技能呢培训
     *
     * @param cmd
     */
    void signUpTraining(SignUpTrainingCommand cmd);

    /**
     * 提交技能培训反馈
     *
     * @param cmd
     */
    void submitFeedBack(SubmitFeedbackCommand cmd);

    /**
     * 美甲作品
     *
     * @param qry
     * @return
     */
    IPage<Works> queryWorks(WorksQuery qry);


    /**
     * 课程记录
     *
     * @param qry
     * @return
     */
    IPage<TrainingStartClass> queryPageClass(TrainingStartClassQuery qry);

    /**
     * 查询
     *
     * @param technicianId
     * @return
     */
    Career career(Integer technicianId);

    /**
     * 获取需要打板的款式
     *
     * @param technicianId
     * @param pageNum
     * @param pageSize
     * @return
     */
    Page<BaseProduce> queryWorkTpl(Integer technicianId, Integer pageNum, Integer pageSize, String searchKeyWord);
}
