package com.gogirl.domain.order.mall;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

@ApiModel("退款订单详情")
@TableName("mall_refund_order_detail")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MallRefundOrderDetail {

    @TableId(type = IdType.ID_WORKER)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("退款订单id")
    private Long mallRefundOrderId;

    @ApiModelProperty("商城购买订单详情id")
    private Long mallOrderDetailId;

    @ApiModelProperty("退货数量")
    private Integer refundNum;

    @ApiModelProperty("退货金额")
    private BigDecimal amount;


}
