package com.gogirl.application.store.career.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.store.career.ITechScoreRulesService;
import com.gogirl.domain.store.career.Career;
import com.gogirl.domain.store.career.TechScoreRules;
import com.gogirl.dto.TechScore;
import com.gogirl.infrastructure.mapper.store.career.CareerMapper;
import com.gogirl.infrastructure.mapper.store.career.TechScoreRulesMapper;
import com.gogirl.infrastructure.util.SessionUtils;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-03-12
 */
@Service
@AllArgsConstructor
public class TechScoreRulesServiceImpl extends ServiceImpl<TechScoreRulesMapper, TechScoreRules> implements ITechScoreRulesService {

    private final CareerMapper careerMapper;

    @Override
    public TechScore getTechScore() {
        Integer technicianId = SessionUtils.getTechnicianId();
        List<TechScoreRules> techScoreRulesList = this.list();
        Career career = careerMapper.selectOne(new LambdaQueryWrapper<Career>()
                .eq(Career::getTechnicianId, technicianId));
        TechScore techScore = new TechScore();
        techScore.setTechScoreRulesList(techScoreRulesList);
        techScore.setTechScore(career.getTechScore());
        return techScore;
    }
}
