package com.gogirl.shared.product.query.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;


/**
 * Created by yinyong on 2018/8/20.
 * 款式
 */
@ApiModel("款式")
@Data
public class BaseProduceDTO implements Serializable {


    private Integer id;

    private Integer serveId;

    @ApiModelProperty("副标题")
    private String subTitle;

    @ApiModelProperty("款式名称")
    private String name;

    @ApiModelProperty("图片")
    private String picturePath;

    @ApiModelProperty("上线下线状态 1-上线 2-下线")
    private String status;

    @ApiModelProperty("文字描述")
    private String details;

    @ApiModelProperty("当前价格")
    private BigDecimal currentPrice;

    @ApiModelProperty("特价")
    private BigDecimal bargainPrice;

    @ApiModelProperty("总点赞次数")
    private Integer praiseSum;

    @ApiModelProperty("服务简介")
    private String briefIntroduction;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("备注")
    private String remark;

    private Integer produceLabelId;

}
