package com.gogirl.interfaces.store;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.store.oa.OvertimeRecord;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.mapper.store.oa.OvertimeRecordMapper;
import com.gogirl.infrastructure.util.SessionUtils;
import com.gogirl.shared.store.query.qry.OrderTimeRecordPageQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

@Api(tags = "version 3.0: 加班记录接口")
@AllArgsConstructor
@RestController
public class OverTimeRecordController {

    private final GogirlTokenService gogirlTokenService;

    private final OvertimeRecordMapper overtimeRecordMapper;

    @ApiOperation("加班记录")
    @PostMapping("/technician/overTimeRecord/queryPage")
    public JsonResult<IPage<OvertimeRecord>> queryPage(@RequestHeader String token,
                                                       @RequestBody OrderTimeRecordPageQuery qry) {

        Calendar cale = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

        // 获取前月的第一天
        cale = Calendar.getInstance();
        cale.add(Calendar.MONTH, -1);
        cale.set(Calendar.DAY_OF_MONTH, 1);
        Date firstDay = cale.getTime();
        Date paramDate = new Date(firstDay.getTime() - 7 * 24 * 60 * 60 * 1000);
        IPage<OvertimeRecord> page = new Page<>();
        page = overtimeRecordMapper.selectPage(page, new LambdaQueryWrapper<OvertimeRecord>()
                .eq(OvertimeRecord::getTechnicianId, SessionUtils.getTechnicianId())
                .gt(OvertimeRecord::getLeftTimeLength, 0)
                .ge(OvertimeRecord::getStartTime, paramDate)
                .ge(OvertimeRecord::getEndTime, paramDate));

        return JsonResult.success(page);
    }
}
