package com.gogirl.interfaces.user.customer;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.domain.common.xcx.Zone;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.mapper.common.xcx.ZoneMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@AllArgsConstructor
@Api(tags = "地址选择器")
public class ZoneController {

    private final ZoneMapper zoneMapper;

    @ApiOperation("获取父目录下的地址信息 pid=0：1级目录")
    @GetMapping("customer/no_zone/listByPid/{pid}")
    public JsonResult<List<Zone>> listByPid(@PathVariable Integer pid) {
        List<Zone> zoneList = zoneMapper.selectList(new LambdaQueryWrapper<Zone>().eq(Zone::getPid, pid));
        return JsonResult.success(zoneList);
    }
}
