package com.gogirl.domain.user.customer;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="Label对象", description="")
public class Label implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "标签名")
    private String name;

    @ApiModelProperty(value = "标签图片")
    private String picUrl;

    @ApiModelProperty(value = "是否需要系统计算")
    private Integer sysCalculation;

    @ApiModelProperty(value = "下单次数 最小")
    private BigDecimal orderCountMin;

    @ApiModelProperty(value = "下单次数 最多")
    private BigDecimal orderCountMax;

    @ApiModelProperty(value = "消费金额 至少")
    private BigDecimal amountMin;

    @ApiModelProperty(value = "消费金额 至多")
    private BigDecimal amountMax;

    @ApiModelProperty(value = "客单价 至少")
    private BigDecimal unitPriceMin;

    @ApiModelProperty(value = "客单价 至多")
    private BigDecimal unitPriceMax;

    @ApiModelProperty(value = "好评数量")
    private BigDecimal praiseMin;

    @ApiModelProperty(value = "好评数量")
    private BigDecimal praiseMax;

    @ApiModelProperty(value = "是否持卡")
    private Integer hasCard;

    @ApiModelProperty(value = "会员等级 逗号隔开")
    private String memberLevels;

    @ApiModelProperty(value = "年龄 ")
    private Integer ageMin;

    @ApiModelProperty(value = "年龄")
    private Integer ageMax;

    @ApiModelProperty(value = "职业 逗号隔开")
    private String jobs;

    @ApiModelProperty(value = "偏好, 逗号隔开")
    private String preference;

    @ApiModelProperty(value = "上次消费至今 多少天内")
    private Integer lastOrderDaysMin;

    @ApiModelProperty(value = "上次消费至今 已经超过多少天")
    private Integer lastOrderDaysMax;

    @ApiModelProperty(value = "客户来源 逗号隔开")
    private String source;

    @ApiModelProperty(value = "做过指定服务")
    private String serviceIds;

    @ApiModelProperty(value = "参与过某某活动")
    private String activityIds;

    @ApiModelProperty(value = "拥有过哪些券")
    private String couponIds;

    @ApiModelProperty(value = "总客户数量")
    private Integer count;

    @ApiModelProperty(value = "总充值次数")
    private Integer rechargeCountMin;

    @ApiModelProperty(value = "充值次数")
    private Integer rechargeCountMax;

    @ApiModelProperty(value = "充值金额")
    private BigDecimal rechargeAmountMin;

    @ApiModelProperty(value = "充值金额")
    private BigDecimal rechargeAmountMax;

    @ApiModelProperty(value = "差评次数 （3星以下）")
    private Integer complaintCountMin;

    @ApiModelProperty(value = "差评次数 （3星以下）")
    private Integer complaintCountMax;

    @ApiModelProperty(value = "在哪些店铺有过消费 （id，逗号隔开）")
    private String storeIds;

    @ApiModelProperty(value = "初次服务的美甲师")
    private String firstTechnicianIds;

    @ApiModelProperty(value = "首次消费的服务")
    private String firstServiceIds;

    @ApiModelProperty(value = "昨天有消费服务")
    private String yesterdayServiceTypeIds;


}
