package com.gogirl;


import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.exception.RRException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 统一异常处理器
 *
 * @author robbendev
 */
@ControllerAdvice
@ResponseBody
@Slf4j
public class RRExceptionHandler {

    /**
     * 自定义异常
     */
    @ExceptionHandler(RRException.class)
    public JsonResult<String> handleRRException(RRException e) {
        JsonResult<String> result = new JsonResult<>();
        result.setSuccess(false);
        result.setCode(e.getCode());
        result.setMessage(e.getMessage());
        if (e.getCode() != 2000) {
            log.error(e.getMessage(), e);
        }
        return result;
    }

    /**
     * 通用异常
     */
    @ExceptionHandler(Exception.class)
    public JsonResult<String> handleException(Exception e) {
        JsonResult<String> result = new JsonResult<>();
        result.setSuccess(false);
        result.setCode(500);
        result.setMessage(e.getMessage());
        log.error(e.getMessage(), e);
        return result;
    }

    @ExceptionHandler(MethodArgumentNotValidException.class)
    public JsonResult<String> MethodArgumentNotValidException(MethodArgumentNotValidException ex) {

        JsonResult<String> result = new JsonResult<>();
        result.setSuccess(false);
        result.setCode(500);
        result.setMessage("参数错误。");
        log.error(ex.getMessage(), ex);
        return result;
    }

}
