package com.gogirl.infrastructure.interceptor;

import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.infrastructure.mapper.store.store.StoreManageMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@AllArgsConstructor
@Component
@Slf4j
public class AuthHandlerInterceptor implements HandlerInterceptor {

    private final GogirlTokenService gogirlTokenService;
    private final StoreManageMapper storeManageMapper;
    private final CustomerMapper customerMapper;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {

        String token = request.getHeader("token");

        if (request.getRequestURI().contains("no_")) {
            return true;
        }

        String sourceFrom = request.getHeader("sourceFrom");
        if (sourceFrom == null) {
            return true;
        }
        if (sourceFrom.equals("customer")) {
            GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
            if (gogirlToken == null) {
                throw new RRException(2000, "token失效，请重新登陆");
            } else {
                Customer customer = customerMapper.selectById(gogirlToken.getCustomerId());
                if (customer != null && StringUtils.isEmpty(customer.getPhone())) {
                    throw new RRException(1001, "请授权手机号码");
                }
            }
        }
        return true;
    }
}
