package com.gogirl.assembler;

import com.gogirl.domain.store.career.CareerWorks;
import com.gogirl.domain.store.career.CareerWorksImages;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.shared.store.WorksDTO;
import com.gogirl.shared.store.WorksImagesDTO;
import lombok.AllArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import java.util.function.Function;
import java.util.stream.Collectors;

@Component
@AllArgsConstructor
public class WorksAssembler implements Function<CareerWorks, WorksDTO> {

    private final WorksImagesDTOAssembler worksImagesDTOAssembler;

    @Override
    public WorksDTO apply(CareerWorks works) {
        WorksDTO worksDTO = new WorksDTO();
        BeanUtils.copyProperties(works, worksDTO);

        if(ListUtil.isNotEmpty(works.getWorksImagesList())){
            worksDTO.setWorksImagesDTOList(
                    works.getWorksImagesList()
                            .stream()
                            .map(worksImagesDTOAssembler)
                            .collect(Collectors.toList())
            );
        }
        return worksDTO;
    }

    @Component
    static class WorksImagesDTOAssembler implements Function<CareerWorksImages, WorksImagesDTO> {

        @Override
        public WorksImagesDTO apply(CareerWorksImages worksImages) {
            WorksImagesDTO worksImagesDTO = new WorksImagesDTO();
            BeanUtils.copyProperties(worksImages, worksImagesDTO);
            return worksImagesDTO;
        }
    }
}
