package com.gogirl.interfaces.user;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.xcx.CustomerMessageService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.application.xcx.VisitLogService;
import com.gogirl.domain.user.customer.CustomerMessage;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.domain.xcx.VisitsLog;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.shared.user.command.ReadMessageCommand;
import com.gogirl.shared.user.query.qry.CustomerMessagePageQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

@RestController
@AllArgsConstructor
@Api(tags = {"version2.0: 消息接口"})
@Slf4j
public class MessageController {

    private final GogirlTokenService gogirlTokenService;
    private final VisitLogService visitLogService;

    private final CustomerMessageService customerMessageService;

    @ApiModelProperty("我的消息")
    @PostMapping("/customer/message/queryPageMessage")
    public JsonResult<Page<CustomerMessage>> queryPageMessage(@RequestHeader String token,
                                                              @RequestBody CustomerMessagePageQuery qry) {
        Page<CustomerMessage> customerMessagePage = customerMessageService.queryPageMessage(qry);
        return JsonResult.success(customerMessagePage);
    }

    @ApiModelProperty("已读消息")
    @PostMapping("/customer/message/customer/readMessage")
    public JsonResult<Void> readMessage(@RequestBody ReadMessageCommand cmd) {
        customerMessageService.readMessage(cmd);
        return JsonResult.success();
    }


    @ApiOperation(value = "小程序登入记录")
    @PostMapping("/customer/message/loginLog")
    public JsonResult<Integer> loginLog(@RequestHeader String token) {
        GogirlToken gt = gogirlTokenService.getByToken(token);
        if (gt == null) {
            throw new RRException(2000, "token失效");
        }
        VisitsLog visitsLog = visitLogService.loginLog(gt.getCustomerId());
        return JsonResult.success(visitsLog.getId());
    }

    @ApiOperation(value = "小程序登出记录")
    @PostMapping("/customer/message/logoutLog")
    public JsonResult<Void> logoutLog(@RequestHeader String token,
                                      @RequestParam Integer visitsId) {
        visitLogService.logoutLog(visitsId);
        return JsonResult.success();
    }

    @ApiOperation(value = "记录该次访问的活动")
    @PostMapping("/customer/message/recordActivityId")
    public JsonResult<Void> recordActivityId(@RequestHeader String token,
                                             @RequestParam Integer visitsId,
                                             @RequestParam Integer activityId) {

        visitLogService.recordActivityId(visitsId, activityId);
        return JsonResult.success();

    }

    @ApiOperation(value = "页面登入记录", notes = "参数直接传过来")
    @PostMapping("/customer/message/pageIn")
    public JsonResult<Integer> pageIn(@RequestHeader String token,
                                      @RequestParam(required = false) Integer type,
                                      @RequestParam(required = false) Integer activityId,
                                      @RequestParam(required = false) Integer shareType,
                                      @RequestParam(required = false) Integer shareUserId,
                                      @RequestParam(required = false) Integer serviceId,
                                      @RequestParam(required = false) Integer departmentId,
                                      @RequestParam(required = false) String pageName,
                                      @RequestParam(required = false) Integer produceId) {

        GogirlToken gt = gogirlTokenService.getByToken(token);
        if (gt == null) {
            throw new RRException(2000, "token失效");
        }
        Integer customerId = gt.getCustomerId();
        VisitsLog visitsLog = visitLogService.pageIn(customerId, type, activityId, shareType, shareUserId, serviceId, departmentId, pageName, produceId);
        return JsonResult.success(visitsLog.getId());
    }


    @ApiOperation(value = "页面登出记录")
    @PostMapping("/customer/message/pageOut")
    public JsonResult<Void> pageOut(@RequestHeader String token,
                                    @RequestParam Integer visitsId) {
        visitLogService.pageOut(visitsId);
        return JsonResult.success();
    }


}
