package com.gogirl.application.store.training.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.store.training.ITrainingStartClassLogTechnicianService;
import com.gogirl.domain.store.training.TrainingCourse;
import com.gogirl.domain.store.training.TrainingFeedback;
import com.gogirl.domain.store.training.TrainingStartClass;
import com.gogirl.domain.store.training.TrainingStartClassLogTechnician;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.infrastructure.mapper.store.training.TrainingCourseMapper;
import com.gogirl.infrastructure.mapper.store.training.TrainingFeedbackMapper;
import com.gogirl.infrastructure.mapper.store.training.TrainingStartClassLogTechnicianMapper;
import com.gogirl.infrastructure.mapper.store.training.TrainingStartClassMapper;
import com.gogirl.shared.store.SignUpTrainingCommand;
import com.gogirl.shared.store.TrainingStartClassQuery;
import com.gogirl.shared.store.training.QueryPageStartClassLogRequest;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 每次开课，参与的美甲师 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-07
 */
@Service
public class TrainingStartClassLogTechnicianServiceImpl extends ServiceImpl<TrainingStartClassLogTechnicianMapper, TrainingStartClassLogTechnician> implements ITrainingStartClassLogTechnicianService {

    @Resource
    TrainingStartClassMapper trainingStartClassMapper;
    @Resource
    TrainingFeedbackMapper trainingFeedbackMapper;
    @Resource
    TrainingCourseMapper trainingCourseMapper;

    @Override
    public void signUpTraining(SignUpTrainingCommand cmd) {

        TrainingStartClassLogTechnician trainingStartClassLogTechnician = baseMapper
                .selectOne(new LambdaQueryWrapper<TrainingStartClassLogTechnician>()
                        .eq(TrainingStartClassLogTechnician::getTrainingStartClassId, cmd.getTrainingStartClassId())
                        .eq(TrainingStartClassLogTechnician::getTechnicianId, cmd.getTechnicianId()));

        if (trainingStartClassLogTechnician != null) {
            throw new RRException(500, "您已经报名过该课程");
        }


        trainingStartClassLogTechnician = TrainingStartClassLogTechnician
                .builder()
                .trainingStartClassId(cmd.getTrainingStartClassId())
                .technicianId(cmd.getTechnicianId())
                .createDate(new Date())
                .build();

        baseMapper.insert(trainingStartClassLogTechnician);
    }

    @Override
    public IPage<TrainingStartClassLogTechnician> queryPageStartClassLog(QueryPageStartClassLogRequest request) {

        Integer technicianId = SessionUtils.getTechnicianId();
        request.setTechnicianId(technicianId);
        IPage<TrainingStartClassLogTechnician> pageRequest = new Page<>(request.getPageNum(), request.getPageSize());

        IPage<TrainingStartClassLogTechnician> page = baseMapper.queryPageStartClassLog(pageRequest, request);

        List<Integer> trainingStartClassIdList = page.getRecords().stream().map(TrainingStartClassLogTechnician::getTrainingStartClassId).collect(Collectors.toList());
        List<Integer> trainingStartClassLogTechnicianIdList = page.getRecords().stream().map(TrainingStartClassLogTechnician::getId).collect(Collectors.toList());

        if (ListUtil.isNotEmpty(trainingStartClassIdList)) {
            Map<Integer, TrainingStartClass> trainingStartClassesMap = trainingStartClassMapper.selectBatchIds(trainingStartClassIdList).stream().collect(Collectors.toMap(TrainingStartClass::getId, trainingStartClass -> trainingStartClass, (k1, k2) -> k1));

            Map<Integer, TrainingFeedback> feedbackMap = trainingFeedbackMapper.selectList(new LambdaQueryWrapper<TrainingFeedback>().in(TrainingFeedback::getTrainingStartClassLogTechnicianId, trainingStartClassLogTechnicianIdList)).stream()
                    .collect(Collectors.toMap(TrainingFeedback::getTrainingStartClassLogTechnicianId, trainingFeedback -> trainingFeedback, (k1, k2) -> k1));

            List<Integer> trainingCourseIdList = trainingStartClassesMap.values().stream().map(TrainingStartClass::getCourseId).collect(Collectors.toList());
            if (ListUtil.isNotEmpty(trainingCourseIdList)) {
                Map<Integer, List<TrainingCourse>> trainingCourseGroup = trainingCourseMapper.listByTrainingStartClassIds(trainingCourseIdList).stream()
                        .collect(Collectors.groupingBy(TrainingCourse::getId);

                trainingStartClassesMap.values().forEach(trainingStartClass -> {
                    trainingStartClass.setTrainingCourseList(trainingCourseGroup.get(trainingStartClass.getCourseId()));
                });
            }

            page.getRecords().forEach(trainingStartClassLogTechnician -> {
                trainingStartClassLogTechnician.setTrainingStartClass(trainingStartClassesMap.get(trainingStartClassLogTechnician.getTrainingStartClassId()));
                trainingStartClassLogTechnician.setTrainingFeedback(feedbackMap.get(trainingStartClassLogTechnician.getId()));
            });


        }

        return page;
    }

    @Override
    public IPage<TrainingStartClass> queryPageClass(TrainingStartClassQuery qry) {
        IPage<TrainingStartClass> page = new Page<>(qry.getPageNum(), qry.getPageSize());
        page = trainingStartClassMapper.selectPage(page, new LambdaQueryWrapper<TrainingStartClass>().eq(TrainingStartClass::getStatus, 1));
        if (ListUtil.isEmpty(page.getRecords())) {
            return page;
        }

        //join
        List<Integer> trainingStartClassIds = page.getRecords().stream().map(TrainingStartClass::getId).collect(Collectors.toList());
        List<TrainingCourse> trainingCourseList = trainingCourseMapper.listByTrainingStartClassIds(trainingStartClassIds);
        Map<Integer, List<TrainingCourse>> map = trainingCourseList.stream().collect(Collectors.groupingBy(TrainingCourse::getId));

        page.getRecords().forEach(trainingStartClass -> {
            if (ListUtil.isNotEmpty(map.get(trainingStartClass.getCourseId()))) {
                trainingStartClass.setTrainingCourseList(map.get(trainingStartClass.getCourseId()));
            }
        });
        return page;
    }


}
