package com.gogirl.application.order.serve.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.order.serve.IOwnProduceService;
import com.gogirl.application.order.serve.IOwnProduceTechniqueSkuService;
import com.gogirl.domain.order.serve.OwnProduce;
import com.gogirl.domain.order.serve.OwnProduceTechniqueSku;
import com.gogirl.domain.product.serve.TechniqueSku;
import com.gogirl.infrastructure.mapper.order.serve.OwnProduceMapper;
import com.gogirl.infrastructure.mapper.product.serve.TechniqueSkuMapper;
import com.gogirl.shared.order.OwnProduceCommand;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-05-27
 */
@Slf4j
@Service
public class OwnProduceServiceImpl extends ServiceImpl<OwnProduceMapper, OwnProduce> implements IOwnProduceService {

    @Resource
    IOwnProduceTechniqueSkuService ownProduceTechniqueSkuService;
    @Resource
    TechniqueSkuMapper techniqueSkuMapper;
    @Resource
    OwnProduceMapper ownProduceMapper;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public OwnProduce saveOrUpdateOwnProduce(OwnProduceCommand command) {

        command.setOwnProduceTechniqueSkuCommandList(command.getOwnProduceTechniqueSkuCommandList()
                .stream().filter(Objects::nonNull)
                .filter(obj -> obj.getTechniqueSkuId() != null)
                .collect(Collectors.toList()));

        OwnProduce ownProduce;

        if (command.getOwnProduceId() == null) {
            ownProduce = new OwnProduce();
        } else {
            ownProduce = this.getById(command.getOwnProduceId());
            ownProduceTechniqueSkuService.remove(new LambdaQueryWrapper<OwnProduceTechniqueSku>().eq(OwnProduceTechniqueSku::getOwnProduceId, ownProduce.getId()));
        }

        List<OwnProduceTechniqueSku> ownProduceTechniqueSkuList = command.getOwnProduceTechniqueSkuCommandList().stream()
                .map(ownProduceTechniqueSkuCommand -> {
                    OwnProduceTechniqueSku ownProduceTechniqueSku = new OwnProduceTechniqueSku();
                    ownProduceTechniqueSku.setQuantity(ownProduceTechniqueSkuCommand.getQuantity());
                    ownProduceTechniqueSku.setTechniqueSkuId(ownProduceTechniqueSkuCommand.getTechniqueSkuId());
                    ownProduceTechniqueSku.setOwnProduceId(ownProduce.getId());
                    return ownProduceTechniqueSku;
                })
                .collect(Collectors.toList());

        ownProduce.setDuration(ownProduceTechniqueSkuList
                .stream()
                .mapToInt(ownProduceTechniqueSku -> {
                    TechniqueSku techniqueSku = techniqueSkuMapper.selectById(ownProduceTechniqueSku.getTechniqueSkuId());
                    return ownProduceTechniqueSku.getQuantity().intValue() * techniqueSku.getDuration();
                })
                .sum());

        ownProduce.setPrice(ownProduceTechniqueSkuList
                .stream()
                .map(ownProduceTechniqueSku -> {
                    TechniqueSku techniqueSku = techniqueSkuMapper.selectById(ownProduceTechniqueSku.getTechniqueSkuId());
                    return ownProduceTechniqueSku.getQuantity().multiply(techniqueSku.getPrice());
                })
                .reduce(BigDecimal.ZERO, BigDecimal::add));

        ownProduce.setName(ownProduceTechniqueSkuList
                .stream()
                .map(ownProduceTechniqueSku -> {
                    TechniqueSku techniqueSku = techniqueSkuMapper.selectById(ownProduceTechniqueSku.getTechniqueSkuId());
                    return techniqueSku.getName() + "x" + ownProduceTechniqueSku.getQuantity();
                })
                .collect(Collectors.joining(",")));
        this.saveOrUpdate(ownProduce);

        ownProduceTechniqueSkuList.forEach(ownProduceTechniqueSku -> ownProduceTechniqueSku.setOwnProduceId(ownProduce.getId()));
        ownProduceTechniqueSkuService.saveBatch(ownProduceTechniqueSkuList);

        return ownProduce;
    }

    @Override
    public List<TechniqueSku> getByOwnProduceId(Integer ownProduceId) {
        return ownProduceMapper.getByOwnProduceId(ownProduceId);
    }
}
