package com.gogirl.domain.market.coupon;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@ApiModel("优惠券配置")
@Data
@TableName("coupon")
public class Coupon {

    @TableId(type = IdType.AUTO)
    private Integer id;

    private String name;

    private BigDecimal discountAmount;

    private BigDecimal reachingAmount;

    private BigDecimal discountPercent;

    private Integer type;

    private String condition1;

    private String note;

    private Integer validType;

    private Integer validDate;

    private Integer sourceType;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date validStartTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date validEndTime;

    private Integer allQuantity;

    private Integer receiveQuantity;

    private Integer useQuantity;

    private Integer limitQuantity;

    private Integer state;

    private Date updateTime;

    private String remark;

    private BigDecimal payAmount;

    private String paySource;

    @ApiModelProperty("1-计算 2-不计算")
    private Integer isCalcAchievement;

    @TableField(exist = false)
    private Integer canBeUse;

}
