package com.gogirl.application.order.serve.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.order.serve.OrderServeService;
import com.gogirl.application.order.serve.OrderServeSkuService;
import com.gogirl.application.order.serve.ScheduleManageService;
import com.gogirl.application.order.serve.ScheduleServeService;
import com.gogirl.application.product.serve.BaseTypeService;
import com.gogirl.application.store.store.StoreClassesTechnicianService;
import com.gogirl.application.user.customer.CustomerService;
import com.gogirl.domain.market.discount.LeisureDiscountConfig;
import com.gogirl.domain.order.serve.*;
import com.gogirl.domain.product.purchase.PurchaseSku;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.domain.product.serve.BaseType;
import com.gogirl.domain.product.serve.TechnicianServe;
import com.gogirl.domain.store.oa.TakeLeaveEvent;
import com.gogirl.domain.store.store.StoreClassesTechnician;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.dto.IdleTimeProgramQuery;
import com.gogirl.dto.LeisureScheduleServe;
import com.gogirl.dto.LeisureScheduleServeQuery;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.CloneUtil;
import com.gogirl.infrastructure.common.util.DateUtils;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.infrastructure.config.GogirlProperties;
import com.gogirl.infrastructure.mapper.market.discount.LeisureDiscountConfigMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderManageMapper;
import com.gogirl.infrastructure.mapper.order.serve.ScheduleManageMapper;
import com.gogirl.infrastructure.mapper.order.serve.ScheduleServeMapper;
import com.gogirl.infrastructure.mapper.product.purchase.PurchaseSkuMapper;
import com.gogirl.infrastructure.mapper.product.serve.BaseProduceMapper;
import com.gogirl.infrastructure.mapper.product.serve.BaseServeMapper;
import com.gogirl.infrastructure.mapper.product.serve.ProducePromotionTimeMapper;
import com.gogirl.infrastructure.mapper.product.serve.TechnicianServeMapper;
import com.gogirl.infrastructure.mapper.store.oa.TakeLeaveEventMapper;
import com.gogirl.infrastructure.mapper.store.store.StoreManageMapper;
import com.gogirl.infrastructure.mapper.store.store.StoreTechnicianMapper;
import com.gogirl.infrastructure.util.MapDistance;
import com.gogirl.infrastructure.util.SessionUtils;
import com.gogirl.shared.order.serve.command.schedule.*;
import com.gogirl.shared.order.serve.query.dto.IdleTimeDTO;
import com.gogirl.shared.order.serve.query.qry.*;
import com.gogirl.shared.order.serve.query.qry.schedule.ScheduleManagePageQuery;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.*;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

import static com.gogirl.domain.order.serve.OrderServe.COMMENT_STATUS_NO;

@Service
@AllArgsConstructor
@Slf4j
@Transactional
public class ScheduleManageServiceImpl extends ServiceImpl<ScheduleManageMapper, ScheduleManage> implements ScheduleManageService {


    private final BaseServeMapper baseServeMapper;
    private final TechnicianServeMapper technicianServeMapper;
    private final TakeLeaveEventMapper takeLeaveEventMapper;
    private final LeisureDiscountConfigMapper leisureDiscountConfigMapper;
    private final ScheduleServeMapper scheduleServeMapper;
    private final StoreTechnicianMapper storeTechnicianMapper;
    private final OrderManageMapper orderManageMapper;
    private final StoreManageMapper storeManageMapper;


    private final StoreClassesTechnicianService storeClassesTechnicianService;
    private final BaseTypeService baseTypeService;
    private final OrderServeSkuService orderServeSkuService;
    private final OrderServeService orderServeService;
    private final CustomerService customerService;

    /**
     * rpc service
     */

    private final GogirlProperties gogirlProperties;
    private final ScheduleManageMapper scheduleManageMapper;
    private final ScheduleServeService scheduleServeService;
    private final PurchaseSkuMapper purchaseSkuMapper;
    private final BaseProduceMapper baseProduceMapper;

    @Override
    public List<StoreTechnicianPeriod> queryStoreTechnicianPeriod(Integer scheduledId,
                                                                  Integer departmentId,
                                                                  String scheduleDate,
                                                                  List<Integer> serveIdList) throws ParseException {

        //1.查询美甲师排班表
        List<StoreClassesTechnician> storeClassesTechnicianList = storeClassesTechnicianService.listClassesTechnician(scheduledId, departmentId, scheduleDate);

        if (ListUtil.isNotEmpty(serveIdList)) {
            //美甲师能做哪些服务config查询
            List<TechnicianServe> technicianServeList = technicianServeMapper.selectList(new LambdaQueryWrapper<TechnicianServe>().in(TechnicianServe::getServeId, serveIdList));

            //过滤不能做服务的美甲师
            storeClassesTechnicianList = storeClassesTechnicianList.stream()
                    .filter(storeClassesTechnician ->
                            technicianServeList.stream().map(TechnicianServe::getTechnicianId).collect(Collectors.toList())
                                    .contains(storeClassesTechnician.getTechnicianManage().getId()))
                    .collect(Collectors.toList());
        }

        List<StoreTechnicianPeriod> storeTechnicianPeriodList = new ArrayList<>();

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        //遍历美甲师排班 获取每个美甲师的不可用时间段
        for (StoreClassesTechnician storeClassesTechnician : storeClassesTechnicianList) {

            //一天开始的时间
            long dayStartTime = simpleDateFormat.parse(scheduleDate + " 00:00:00").getTime();
            //一天结束的时间
            long dayEndTime = simpleDateFormat.parse(scheduleDate + " 23:59:59").getTime();

            //上班开始时间str
            String startTime = storeClassesTechnician.getClassesManage().getStartTime().toString();
            //上班结束时间str
            String endTime = storeClassesTechnician.getClassesManage().getEndTime().toString();

            //上班开始时间
            long workStartTime = simpleDateFormat.parse(scheduleDate + " " + startTime).getTime();
            //上班结束时间
            long workEndTime = simpleDateFormat.parse(scheduleDate + " " + endTime).getTime();

            //最晚可预约时间
            String latestScheduledTime = storeClassesTechnician.getClassesManage().getLatestScheduledTime().toString();


            //美甲师正在服务的时间为不可用时间
            List<ScheduleServe> scheduleServeList = storeClassesTechnician.getListScheduleServe();

            //正在服务时间不可用
            List<Period> periodList = scheduleServeList.stream()
                    .map(scheduleServe -> new Period(scheduleServe.getStartTime().getTime(), scheduleServe.getEndTime().getTime()))
                    .collect(Collectors.toList());


            //当前时间之前不可用
            Period period2 = new Period(dayStartTime, System.currentTimeMillis());
            periodList.add(period2);


            //最晚可预约时间
            if (StringUtils.isNotEmpty(latestScheduledTime)
                    && storeClassesTechnician.getClassesManage().getLatestScheduledTimeEnable() == 1) {
                long latestScheduledTimeMills = simpleDateFormat.parse(scheduleDate + " " + latestScheduledTime).getTime();
                Period latestScheduledTimeMillsPeriod = new Period(latestScheduledTimeMills, dayEndTime);
                periodList.add(latestScheduledTimeMillsPeriod);
            }

            //上班开始时间之前的时间不可用
            Period period3 = new Period(dayStartTime, workStartTime);
            periodList.add(period3);

            //请假时间不可用
            List<Period> takeLeavePeriodList = takeLeaveEventMapper.selectList(new LambdaQueryWrapper<TakeLeaveEvent>()
                    .eq(TakeLeaveEvent::getApplyTechnicianId, storeClassesTechnician.getTechnicianManage().getId())
                    .eq(TakeLeaveEvent::getStatus, TakeLeaveEvent.STATUS_APPROVAL_PASS)
                    .in(TakeLeaveEvent::getType, Lists.newArrayList(2, 3, 4, 5, 6)))
                    .stream()
                    .map(takeLeaveEvent -> new Period(takeLeaveEvent.getStartTime(), takeLeaveEvent.getEndTime()))
                    .collect(Collectors.toList());

            periodList.addAll(takeLeavePeriodList);

            //10点上班的
            if (startTime.equals("10:00:00")) {

                //下班后多久的时间是可用的
                Period period4 = new Period(workEndTime, dayEndTime);
                periodList.add(period4);
            }

            StoreTechnician storeTechnician = storeClassesTechnician.getTechnicianManage();
            StoreTechnicianPeriod storeTechnicianDTO = new StoreTechnicianPeriod(
                    periodList,
                    storeTechnician.getId(),
                    storeTechnician.getName(),
                    storeTechnician.getPicturePath(),
                    storeTechnician.getGrade()
            );
            storeTechnicianPeriodList.add(storeTechnicianDTO);
        }

        return storeTechnicianPeriodList;
    }

    @Override
    public List<StoreTechnician> queryLeisureTechnician(Integer departmentId,
                                                        Integer serveId,
                                                        LocalDateTime serveStartTime,
                                                        LocalDateTime serveEndTime) throws ParseException {
        List<StoreTechnicianPeriod> storeTechnicianPeriodList = this.queryStoreTechnicianPeriod(null, departmentId, serveStartTime.toLocalDate().toString(), Lists.newArrayList(serveId));
        Period servePeriod = new Period(serveStartTime.toInstant(ZoneOffset.of("+8")).toEpochMilli(),
                serveEndTime.toInstant(ZoneOffset.of("+8")).toEpochMilli());
        List<Integer> technicianIds = storeTechnicianPeriodList.stream().filter(storeTechnicianPeriod ->
                !storeTechnicianPeriod.getPeriodList().stream().map(period -> period.conflict(servePeriod))
                        .collect(Collectors.toList()).contains(true))
                .map(StoreTechnicianPeriod::getTechnicianId)
                .collect(Collectors.toList());
        if (ListUtil.isNotEmpty(technicianIds)) {
            return storeTechnicianMapper.selectBatchIds(technicianIds);
        }
        return Lists.newArrayList();
    }


    @Override
    public List<IdleTimeDTO> queryIdleTime(IdleTimeProgramQuery qry) throws ParseException {

        IdleTimeQuery idleTimeQuery = new IdleTimeQuery();

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        //美甲师不可用日期列表
        List<StoreTechnicianPeriod> storeTechnicianDTOList = this.queryStoreTechnicianPeriod(qry.getId(), qry.getDepartmentId(), qry.getScheduleDate(), qry.getListScheduleServer().stream().map(ScheduleServe::getServeId).collect(Collectors.toList()));

        idleTimeQuery.setStoreTechnicianDTOList(storeTechnicianDTOList);

        long start3Time = simpleDateFormat.parse(qry.getScheduleDate() + " 10:00:00").getTime();

        long end3Time = simpleDateFormat.parse(qry.getScheduleDate() + " 22:00:00").getTime();

        List<Long> dateTimeList = new ArrayList<>();
        while (start3Time < end3Time) {
            dateTimeList.add(start3Time);
            start3Time = start3Time + 15 * 60000;
        }

        idleTimeQuery.setDateTimeList(dateTimeList);

        idleTimeQuery.setScheduleServeQueryList(qry.getListScheduleServer()
                .stream()
                .map(scheduleServe -> {
                    ScheduleServeQuery scheduleServeQuery = new ScheduleServeQuery();
                    BeanUtils.copyProperties(scheduleServe, scheduleServeQuery);
                    scheduleServeQuery.setLengthTimeForEndTime(baseServeMapper.selectById(scheduleServe.getServeId()).getServiceDuration());
                    BaseServe baseServe = baseServeMapper.selectById(scheduleServe.getServeId());
                    log.debug("-------,{}", baseServe.toString());
                    scheduleServeQuery.setServePicturePath(baseServe.getPicturePath());
                    scheduleServeQuery.setServeName(baseServe.getName());
                    return scheduleServeQuery;
                })
                .collect(Collectors.toList()));


        //预约服务
        List<ScheduleServeQuery> scheduleServeDTOList = idleTimeQuery.getScheduleServeQueryList();

        //预约子服务
        List<ScheduleServeQuery> subServeDTOList = scheduleServeDTOList.stream()
                .filter(scheduleServe -> scheduleServe.getMainServeId() != null)
                .collect(Collectors.toList());

        //预约主服务
        Queue<ScheduleServeQuery> mainServeDTOList = scheduleServeDTOList.stream()
                .filter(scheduleServe -> scheduleServe.getMainServeId() == null)
                .collect(Collectors.toCollection(LinkedList::new));

        //添加子服务的时间到主服务
        mainServeDTOList.forEach(scheduleServeDTO -> {
            subServeDTOList.forEach(subServeDTO -> {
                if (subServeDTO.getMainServeId().equals(scheduleServeDTO.getServeId())) {
                    scheduleServeDTO.setLengthTimeForEndTime(
                            scheduleServeDTO.getLengthTimeForEndTime() + subServeDTO.getLengthTimeForEndTime()
                    );
                }
            });
        });

        //
        List<IdleTimeDTO> idleTimeDTOList = idleTimeQuery.getDateTimeList()
                .stream()
                .map(dateTime -> {

                    AtomicLong time = new AtomicLong(System.currentTimeMillis());

                    //每个主服务由不同的美甲师做，setter主服务的时间period
                    mainServeDTOList.forEach(mainServeDTO -> {
                        Period period = new Period();
                        period.setStartTime(dateTime);
                        period.setLength(mainServeDTO.getLengthTimeForEndTime().longValue() * 60000);
                        period.setEndTime(dateTime + period.getLength());
                        mainServeDTO.setPeriod(period);
                    });

                    //主服务深度克隆
                    List<ScheduleServeQuery> cloneMainServeDTOList = mainServeDTOList.stream().map(CloneUtil::deepClone).collect(Collectors.toList());

                    //美甲师深度克隆
                    List<StoreTechnicianPeriod> cloneStoreTechnicianDTOList = idleTimeQuery.getStoreTechnicianDTOList().stream().map(CloneUtil::deepClone).collect(Collectors.toList());

                    //构造预约方案树🌲
                    TreeProgram treeProgram = this.rec(new LinkedList<>(cloneMainServeDTOList), cloneStoreTechnicianDTOList, TreeProgram.root());

                    log.debug("spendTime:{}", System.currentTimeMillis() - time.get());
                    time.set(System.currentTimeMillis());

                    List<TreeProgram> defaultNodes = new ArrayList<>();

                    //构造默认美甲师
                    this.recDefault(defaultNodes, treeProgram);
                    log.debug("构造默认美甲师Time:{}", System.currentTimeMillis() - time.get());
                    time.set(System.currentTimeMillis());

                    IdleTimeDTO idleTimeDTO = new IdleTimeDTO();
                    idleTimeDTO.setDateTime(dateTime);
                    idleTimeDTO.setTime(new SimpleDateFormat("HH:mm").format(new Date(dateTime)));
                    idleTimeDTO.setStatus(!treeProgram.childNull());
                    idleTimeDTO.setTreeProgram(treeProgram);
                    idleTimeDTO.setDefaultNodeList(defaultNodes);
                    return idleTimeDTO;

                })
                .collect(Collectors.toList());

//
//        for (IdleTimeDTO idleTimeDTO : idleTimeDTOList) {
//            List<ScheduleServeQuery> scheduleServeQueryList = idleTimeDTO.getDefaultNodeList().stream().map(TreeProgram::getScheduleServeQuery).collect(Collectors.toList());
//            for (ScheduleServeQuery scheduleServeQuery : scheduleServeQueryList) {
//                if (this.isLeisureTime(idleTimeDTO.getTime(), idleTimeDTO.getDateTime(), scheduleServeQuery.getServeId())) {
//                    //闲时打折
//                    idleTimeDTO.setIsLeisureDiscount(1);
//                }
//            }
//        }
        return idleTimeDTOList;
    }

    private void recDefault(List<TreeProgram> list,
                            TreeProgram parent) {
        if (!CollectionUtils.isEmpty(parent.getChildList())) {
            TreeProgram treeProgram = new TreeProgram();
            TreeProgram defaultNode = parent.getChildList()
                    .stream()
                    .filter(treeProgram1 ->
                            !treeProgram1.getStoreTechnicianDTO().equals(parent.getStoreTechnicianDTO())
                    )
                    .findAny()
                    .orElse(parent.getChildList().get(0));

            treeProgram.setScheduleServeQuery(defaultNode.getScheduleServeQuery());
            treeProgram.setStoreTechnicianDTO(defaultNode.getStoreTechnicianDTO());
            list.add(treeProgram);

            this.recDefault(list, defaultNode);
        }
    }

    private TreeProgram rec(Queue<ScheduleServeQuery> scheduleServeQueryList,
                            List<StoreTechnicianPeriod> storeTechnicians,
                            TreeProgram parent) {

        long time = System.currentTimeMillis();
        final ScheduleServeQuery scheduleServeQuery = scheduleServeQueryList.poll();

        List<TreeProgram> childList = Lists.newArrayList();

        //遍历每一个美甲师
        storeTechnicians.forEach(storeTechnician -> {
//            long nodeTime = System.currentTimeMillis();
            //美甲师深度克隆
            List<TreeProgram> pathClone = parent.getPath().stream().map(CloneUtil::deepClone).filter(Objects::nonNull)
                    .collect(Collectors.toList());

            //包含当前美甲师的父节点list
            List<ScheduleServeQuery> severedList = pathClone
                    .stream()
                    //根节点到当前节点和
                    .filter(node -> node.getStoreTechnicianDTO().getTechnicianId().equals(storeTechnician.getTechnicianId()))
                    .map(TreeProgram::getScheduleServeQuery)
                    .collect(Collectors.toList());


            TreeProgram t = CloneUtil.deepClone(parent);
            List<StoreTechnicianPeriod> treeProgramList = Lists.newArrayList();

            while (t != null && t.getParent() != null) {
                if (t.getStoreTechnicianDTO() != null) {
                    treeProgramList.add(t.getStoreTechnicianDTO());
                }
                t = t.getParent();
            }
            List<Integer> technicianIds = treeProgramList.stream().map(StoreTechnicianPeriod::getTechnicianId).collect(Collectors.toList());
            Integer technicianId = storeTechnician.getTechnicianId();

            log.info("technicianIds:{},technicianId:{}", technicianIds, technicianId);
            boolean b = technicianIds.contains(technicianId);

            //如果已经设置该美甲师的节点不为空 需要把当前节点的服务时间加上
            TreeProgram node;
            if (b) {
                Long totalServeTime = severedList.stream()
                        .map(ScheduleServeQuery::getPeriod)
                        .map(Period::getLength)
                        .mapToLong(Long::longValue)
                        .sum();
                ScheduleServeQuery scheduleServeQueryClone = CloneUtil.deepClone(scheduleServeQuery);

                Period period = scheduleServeQueryClone.getPeriod();

                period.setStartTime(period.getStartTime() + totalServeTime);
                period.setEndTime(period.getEndTime() + totalServeTime);
                node = new TreeProgram(storeTechnician, scheduleServeQueryClone, parent);
            } else {
                ScheduleServeQuery scheduleServeQueryClone = CloneUtil.deepClone(scheduleServeQuery);
                node = new TreeProgram(storeTechnician, scheduleServeQueryClone, parent);
            }
            //判断该节点的路径是否满足要求
            if (this.test(node.getPath())) {

                //如果还有服务 继续构造子树
                if (!CollectionUtils.isEmpty(scheduleServeQueryList)) {
                    Queue<ScheduleServeQuery> cloneScheduleServeQueryList = scheduleServeQueryList.stream().map(CloneUtil::deepClone).collect(Collectors.toCollection(LinkedList::new));
                    this.rec(cloneScheduleServeQueryList, storeTechnicians, node);

                    //如果构造的子树为空
                    if (!node.childNull()) {
                        childList.add(node);
                    }
                }
                //如果没有服务了 说明是叶子节点，直接添加
                else {
                    childList.add(node);
                }
            }
        });

        parent.setChildList(childList);
        log.info("构造子树时间:{} ,父亲节点:{}", System.currentTimeMillis() - time, parent.getStoreTechnicianDTO());
        return parent;
    }

    private boolean test(List<TreeProgram> path) {

        Map<StoreTechnicianPeriod, List<TreeProgram>> map = path.stream()
                .collect(Collectors.groupingBy(TreeProgram::getStoreTechnicianDTO));

        List<TreeProgram> treePrograms = map.values().stream()

                .map(list -> {
                    TreeProgram node = list.stream().findAny().orElseThrow(RRException::new);

                    TreeProgram cloneNode = new TreeProgram();
                    cloneNode.setStoreTechnicianDTO(CloneUtil.deepClone(node.getStoreTechnicianDTO()));
                    cloneNode.setScheduleServeQuery(CloneUtil.deepClone(node.getScheduleServeQuery()));

                    long totalLength = list.stream().mapToLong(var -> var.getScheduleServeQuery().getPeriod().getLength()).sum();
                    Period period = cloneNode.getScheduleServeQuery().getPeriod();
                    period.setLength(totalLength);
                    period.setEndTime(period.getStartTime() + totalLength);

                    return cloneNode;
                })
                .collect(Collectors.toList());

        boolean bool = true;

        for (TreeProgram treeProgram : treePrograms) {
            StoreTechnicianPeriod storeTechnician = treeProgram.getStoreTechnicianDTO();

            ScheduleServeQuery scheduleServeQuery = treeProgram.getScheduleServeQuery();
            for (Period period : storeTechnician.getPeriodList()) {
                if (period.conflict(scheduleServeQuery.getPeriod())) {
                    bool = false;
                }
            }
        }

        return bool;
    }

    @Override
    public List<IdleTimeDTO> queryLeisureTime(Integer departmentId, String scheduleDate) throws ParseException {


        Date today = new SimpleDateFormat("yyyy-MM-dd").parse(scheduleDate);
        Calendar c = Calendar.getInstance();
        c.setTime(today);
        int weekday = c.get(Calendar.DAY_OF_WEEK);

        if (weekday == 1) {
            weekday = 7;
        } else {
            weekday = weekday - 1;
        }

        List<LeisureDiscountConfig> leisureDiscountConfigList = leisureDiscountConfigMapper.selectByDepartmentIdAndWeekIgnoreLimit(departmentId, weekday);


        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Set<Long> dateTimeListSet = new HashSet<>();

        for (LeisureDiscountConfig leisureDiscountConfig : leisureDiscountConfigList) {

            long startTime = simpleDateFormat.parse(scheduleDate + " " + leisureDiscountConfig.getStartTime().toString()).getTime();
            long endTime = simpleDateFormat.parse(scheduleDate + " " + leisureDiscountConfig.getEndTime().toString()).getTime();

            while (startTime <= endTime) {
                dateTimeListSet.add(startTime);
                startTime = startTime + 15 * 60000;
            }
        }


        List<Long> dateTimeList = new ArrayList<>(dateTimeListSet);
        dateTimeList.sort(Comparator.comparing(Long::longValue));

        //查询显示折扣对应的时间最短的服务shortestServe
        List<BaseServe> baseServeList = leisureDiscountConfigMapper.selectByDepartmentId(departmentId, weekday);
        if (ListUtil.isEmpty(baseServeList)) {
            return Lists.newArrayList();
        }

        List<StoreTechnicianPeriod> storeTechnicianPeriodList = this.queryStoreTechnicianPeriod(null, departmentId, scheduleDate, null);

        int finalWeekday = weekday;
        List<IdleTimeDTO> result = dateTimeList.stream()
                .map(dateTime -> {
                    IdleTimeDTO idleTimeDTO = new IdleTimeDTO();
                    idleTimeDTO.setDateTime(dateTime);
                    idleTimeDTO.setTime(new SimpleDateFormat("HH:mm").format(new Date(dateTime)));
                    List<LeisureTechServe> leisureTechServeList = new ArrayList<>();

                    List<BaseServe> list = leisureDiscountConfigMapper.selectByDepartmentIdAndWeekAndDateTime(departmentId, finalWeekday, idleTimeDTO.getTime());
                    storeTechnicianPeriodList.forEach(storeTechnicianPeriod -> {
                        List<BaseServe> canScheduledServeList = list.stream()
                                .filter(baseServe -> {
                                    Period servePeriod = new Period(dateTime, dateTime + baseServe.getServiceDuration() * 60L * 1000);
                                    //如果和美甲师空闲列表冲突 返回false过滤
                                    boolean b = storeTechnicianPeriod.getPeriodList().stream().map(period -> period.conflict(servePeriod)).collect(Collectors.toList()).contains(true);
                                    return !b;
                                })
                                .collect(Collectors.toList());
                        canScheduledServeList.forEach(canScheduledServe -> {
                            this.addLeisureTechServe(leisureTechServeList, storeTechnicianPeriod.getTechnicianId(), canScheduledServe.getId());
                        });
                    });
                    idleTimeDTO.setIsLeisureDiscount(1);
                    idleTimeDTO.setLeisureTechServeList(leisureTechServeList);
                    idleTimeDTO.setStatus(ListUtil.isNotEmpty(leisureTechServeList));
                    return idleTimeDTO;
                })
                .collect(Collectors.toList());
        return result;
    }

    @Override
    public void cancelSchedule(CancelScheduleCommand cmd) {

        ScheduleManage scheduleManage = scheduleManageMapper.selectById(cmd.getScheduleId());

        //预约状态检测
        if (!scheduleManage.getStatus().equals(ScheduleManage.STATUS_SCHEDULED)) {
            if (scheduleManage.getStatus().equals(ScheduleManage.STATUS_SCHEDULED)) {
                throw new RRException(500, "预约状态异常");
            }
        }
        scheduleManage.setStatus(ScheduleManage.STATUS_CANCEL_SCHEDULED);

        List<ScheduleServe> scheduleServeList = scheduleServeMapper.selectList(new LambdaQueryWrapper<ScheduleServe>().eq(ScheduleServe::getSchId, scheduleManage.getId()));
        scheduleServeList.forEach(scheduleServe -> {
            LeisureDiscountConfig leisureDiscountConfig = leisureDiscountConfigMapper.selectById(scheduleServe.getLeisureDiscountConfigId());
            if (leisureDiscountConfig != null) {
                leisureDiscountConfig.setLeftTimes(leisureDiscountConfig.getLeftTimes() + 1);
                leisureDiscountConfigMapper.updateById(leisureDiscountConfig);
            }
        });

        scheduleManageMapper.updateById(scheduleManage);
    }

    @Override
    public List<ScheduleServe> listScheduleServeNotContainOrderId(String startDateTime, String endDateTime, Integer departmentId, Integer orderId) {
        return scheduleManageMapper.listScheduleServeNotContainOrderId(startDateTime, endDateTime, departmentId, orderId);
    }

    @Override
    public void updateScheduledServeStatus(Integer scheduleServeId, Integer status, Integer forceLeisureConfig) {
        ScheduleServe scheduleServe = scheduleServeMapper.selectById(scheduleServeId);

        //所有需要更新的服务
        List<ScheduleServe> updateList = scheduleServeMapper.selectList(new LambdaQueryWrapper<ScheduleServe>()
                .eq(ScheduleServe::getSchId, scheduleServe.getSchId())
                .eq(ScheduleServe::getServeId, scheduleServe.getServeId()));

        ScheduleManage scheduleManage = scheduleManageMapper.selectById(scheduleServe.getSchId());

        //更新某一个服务状态已完成
        if (status == 3) {
            //预约实际结束时间
            updateList.forEach(val -> {
                val.setStatus(status);
                val.setActualEndTime(new Date());
                scheduleServeMapper.updateById(val);
            });

            List<ScheduleServe> scheduleServeList = scheduleServeMapper.selectList(new LambdaQueryWrapper<ScheduleServe>().eq(ScheduleServe::getSchId, scheduleServe.getSchId()));
            //去重之后的set
            scheduleManage.addScheduleServeList(scheduleServeList);
            scheduleManage.setScheduleServeList(scheduleServeList);

            Set<ScheduleServe> scheduleServeSet = scheduleManage.getListScheduleServer();


            //如果所有的服务状态都是已完成
            if (!scheduleServeSet.stream().map(ScheduleServe::getStatus).map(stats -> stats == 3).collect(Collectors.toList()).contains(false)) {

                if (!scheduleManage.getStatus().equals(8) && scheduleManage.getStatus() != 3) {
                    throw new RRException("重复请求");
                }
                //更新预约状态已完成（守约）
                scheduleManage.setStatus(ScheduleManage.STATUS_KEEP_SCHEDULED);
                scheduleManage.setLastUpdateTime(new Date());
                scheduleManageMapper.updateById(scheduleManage);
                this.createOrder(scheduleManage);
            }
        }

        //开始服务
        if (status == 2) {
            updateList.forEach(val -> {
                val.setStatus(status);
                val.setActualStartTime(new Date());
                //1-是 2-否
                if (forceLeisureConfig != null && forceLeisureConfig != 1) {
                    Integer result = this.getScheduledServeLeisure(val.getId());
                    if (result == 2) {
                        val.setLeisureDiscountConfigId(null);
                        val.setDiscountRate(BigDecimal.ZERO);
                    }
                }
                scheduleServeMapper.updateById(val);
            });
            List<ScheduleServe> scheduleServeList = scheduleServeMapper.selectList(new LambdaQueryWrapper<ScheduleServe>().eq(ScheduleServe::getSchId, scheduleServe.getSchId()));
            //去重之后的set
            scheduleManage.addScheduleServeList(scheduleServeList);
            scheduleManage.setScheduleServeList(scheduleServeList);

            Set<ScheduleServe> scheduleServeSet = scheduleManage.getListScheduleServer();

            if (!scheduleServeSet.stream().map(ScheduleServe::getStatus).map(stats -> stats == 3 || stats == 2).collect(Collectors.toList()).contains(false)) {
                //守约
                scheduleManage.setStatus(8);
                scheduleManage.setLastUpdateTime(new Date());
                //预约的开单时间 为第一个预约的开单时间
                if (scheduleManage.getOpenbillTime() == null) {
                    scheduleManage.setOpenbillTime(new Date());
                }
                scheduleManageMapper.updateById(scheduleManage);
            }
        }
    }

    @Override
    public void checkBeforeTakeOrders(Integer technicianId, Integer scheduleId) {
        List<ScheduleServe> scheduleServeList = scheduleServeService.list(new LambdaQueryWrapper<ScheduleServe>().eq(ScheduleServe::getSchId, scheduleId));
        scheduleServeList.forEach(scheduleServe -> {
            List<ScheduleServe> conflictScheduleServeList = scheduleManageMapper.checkConflict(scheduleServe.getStartTime(), scheduleServe.getEndTime(), technicianId, scheduleId);
            if (ListUtil.isNotEmpty(conflictScheduleServeList)) {
                throw new RRException(2003, "冲突");
            }
        });
    }

    private void addLeisureTechServe(List<LeisureTechServe> leisureTechServeList, Integer technicianId, Integer serveId) {
        leisureTechServeList.stream()
                .filter(leisureTechServe -> leisureTechServe.getServeId().equals(serveId))
                .findAny()
                .map(leisureTechServe -> leisureTechServe.getTechnicianIdList().add(technicianId))
                .orElseGet(() -> {
                    LeisureTechServe leisureTechServe = new LeisureTechServe();
                    leisureTechServe.setServeId(serveId);
                    Set<Integer> set = new HashSet<>();
                    set.add(technicianId);
                    leisureTechServe.setTechnicianIdList(set);
                    leisureTechServeList.add(leisureTechServe);
                    return null;
                });
    }

    private boolean isLeisureTime(String time, Long timeSeconds, Integer serveId) throws ParseException {

        Date date = new Date(timeSeconds);

        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int weekday = c.get(Calendar.DAY_OF_WEEK);
        if (weekday == 1) {
            weekday = 7;
        } else {
            weekday = weekday - 1;
        }

        List<LeisureDiscountConfig> leisureDiscountConfigList = leisureDiscountConfigMapper.selectIsLeisureTime(time, serveId, weekday);
        return ListUtil.isNotEmpty(leisureDiscountConfigList);
    }

    /**
     * 店铺短码-服务短码（s）-美甲师短码-时间-4位最大单号
     *
     * @param departmentId
     * @param scheduleId
     * @return
     */
    private String getOrderNo(Integer departmentId, Integer scheduleId) {

        StoreManage storeManage = storeManageMapper.selectById(departmentId);
        List<ScheduleServe> scheduleServeList = scheduleServeMapper.selectList(new LambdaQueryWrapper<ScheduleServe>().eq(ScheduleServe::getSchId, scheduleId));
        BaseServe baseServe = baseServeMapper.selectById(scheduleServeList.get(0).getServeId());
        BaseType baseType = baseTypeService.getById(baseServe.getTypeId());
        StoreTechnician storeTechnician = storeTechnicianMapper.selectById(scheduleServeList.get(0).getTechnicianId());

        OrderManage latestOfDay = orderManageMapper.latestOfDay();

        String latestOfDayString;
        //
        if (latestOfDay == null) {
            latestOfDayString = "0001";
        }
        //
        else {
            latestOfDayString = String.format("%04d", Integer.parseInt(latestOfDay.getOrderNo().substring(latestOfDay.getOrderNo().length() - 4)) + 1);
        }
        //
        return (storeManage.getShortCode() == null ? "NNN" : storeManage.getShortCode()) + "-" +
                (StringUtils.isEmpty(baseType.getShortCode()) ? "NNN" : baseType.getShortCode()) + "-" +
                (StringUtils.isEmpty(storeTechnician.getShortCode()) ? "NNN" : storeTechnician.getShortCode()) + "-" +
                new SimpleDateFormat("yyMMdd").format(new Date()) + "-" +
                latestOfDayString;
    }

    private void validSubmit(SubmitScheduleCommand cmd) {

        ScheduleManageCommand scheduleManageDTO = cmd.getScheduleManageDTO();
        cmd.getScheduleManageDTO().getScheduleServeDTOList().forEach(scheduleServeCommand -> {
            if (scheduleServeCommand.getMainServeId() == null) {
                BaseServe baseServe = baseServeMapper.selectById(scheduleServeCommand.getServeId());
                List<ScheduleServe> typeConflictScheduleServe = scheduleServeMapper.selectConflictType(
                        scheduleManageDTO.getScheduledUser(), scheduleManageDTO.getArriveTime(), baseServe.getType());
                if (ListUtil.isNotEmpty(typeConflictScheduleServe)) {
                    throw new RRException("同类型服务一天只能预约一次");
                }
            }
        });
    }

    private String getScheduleNo(Integer deparmentId) {

        //调用店铺服务根据id查询店铺
        StoreManage storeManage = storeManageMapper.selectById(deparmentId);

        //生成预约单号
        String shortCode = storeManage.getShortCode();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd");
        String day = simpleDateFormat.format(new Date());

        String lastOfDayString;
        ScheduleManage lastOfDay = scheduleManageMapper.lastOfDay();
        //第一单
        if (lastOfDay == null) {
            lastOfDayString = "0001";
        }
        //累加
        else {
            lastOfDayString = String.format("%04d", (Integer.parseInt(lastOfDay.getScheduledNo().substring(lastOfDay.getScheduledNo().length() - 4)) + 1));
        }
        return shortCode + day + lastOfDayString;
    }

    @Override
    public void submitSchedule(SubmitScheduleCommand cmd) {

        this.validSubmit(cmd);
        cmd.getScheduleManageDTO().setScheduledUser(SessionUtils.getCustomerId());
        ScheduleManage scheduleManage = this.setScheduleServe(cmd.getScheduleManageDTO(), cmd.getDefaultNodeList());

        //状态 已预约
        scheduleManage.setStatus(ScheduleManage.STATUS_SCHEDULED);
        //最近更新时间
        scheduleManage.setLastUpdateTime(new Date());
        //预约时间
        scheduleManage.setScheduledTime(new Date());
        scheduleManage.setRemark(scheduleManage.getScheduledUser() + "用户提交预约");
        //保存预约
        scheduleManageMapper.insert(scheduleManage);

        scheduleManage.getScheduleServeList().forEach(scheduleServe -> {
            scheduleServe.setCreateTime(new Date());
            scheduleServe.setSchId(scheduleManage.getId());
        });
        //保存预约详情
        scheduleManage.getScheduleServeList().forEach(scheduleServeMapper::insert);
    }

    @Override
    public void updateSchedule(SubmitScheduleCommand cmd) {

        log.info("更新预约:{}", cmd);

        ScheduleManage scheduleManage = this.setScheduleServe(cmd.getScheduleManageDTO(), cmd.getDefaultNodeList());

        scheduleManage.setLastUpdateTime(new Date());
//        scheduleManage.setRemark(SessionUtils.getTechnicianId() + "美甲师修改预约");
        //更次预约
        scheduleManageMapper.updateById(scheduleManage);
        List<Integer> oldScheduleServeIds = scheduleServeMapper.selectList(new LambdaQueryWrapper<ScheduleServe>().eq(ScheduleServe::getSchId, scheduleManage.getId())).stream().map(ScheduleServe::getId).collect(Collectors.toList());
        List<ScheduleServe> scheduleServeList = scheduleManage.getScheduleServeList();
        scheduleServeList.forEach(scheduleServe -> scheduleServe.setSchId(scheduleManage.getId()));

        scheduleServeList.forEach(scheduleServe -> {
            if (scheduleServe.getId() != null) {
                scheduleServeMapper.updateById(scheduleServe);
            } else {
                scheduleServeMapper.insert(scheduleServe);
            }
        });
        List<Integer> removeIds = oldScheduleServeIds.stream().filter(id -> !scheduleServeList.stream().map(ScheduleServe::getId).collect(Collectors.toList()).contains(id)).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(removeIds)) {
            scheduleServeMapper.deleteBatchIds(removeIds);
        }
        scheduleManage.addScheduleServeList(scheduleServeList);
        this.createOrder(scheduleManage);
    }

    @Override
    public void checkBeforeUpdate(UpdateScheduleCommand cmd) {

    }

    @Override
    public List<Map<String, Object>> queryReservableTime(String startDate, Integer lengthTime, Integer departmentId, Integer orderId, Boolean needRemoveOldServe) {
        if (startDate == null || lengthTime == null) {
            log.info("传递参数为空：" + "开始时间：" + startDate + "时长：" + lengthTime);
            throw new RRException("null param startDate or lengthTime");
        }
        if (needRemoveOldServe != null && needRemoveOldServe) {
            lengthTime += 30;
        }

        log.info("获取可选取日期时间列表开始...");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startTime = gogirlProperties.getStartTime();
        String endDateTime;
        String startDateTime = startDate + " " + startTime;
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            int timeNode = 15;
            while (simpleDateFormat.parse(startDateTime).before(simpleDateFormat.parse(startDate + " " + gogirlProperties.getEndTime()))) {
                Map<String, Object> statusMap = new HashMap<String, Object>();
                Date startDateTimeFormat = simpleDateFormat.parse(startDateTime);
                startDate = new SimpleDateFormat("yyyy-MM-dd").format(startDateTimeFormat);
                startTime = new SimpleDateFormat("HH:mm:ss").format(startDateTimeFormat);
                Calendar cal = Calendar.getInstance();
                if (simpleDateFormat.parse(startDateTime).before(new Date())) {
                    if (needRemoveOldServe == null) {
                        statusMap.put("status", true);
                        statusMap.put("time", startTime);
                        list.add(statusMap);
                        cal.setTime(startDateTimeFormat);
                        cal.add(Calendar.MINUTE, timeNode);
                        startDateTime = simpleDateFormat.format(cal.getTime());
                        continue;
                    } else {
                        statusMap.put("status", false);
                        statusMap.put("time", startTime);
                        list.add(statusMap);
                        cal.setTime(startDateTimeFormat);
                        cal.add(Calendar.MINUTE, timeNode);
                        startDateTime = simpleDateFormat.format(cal.getTime());
                        continue;
                    }
                }
                cal.setTime(startDateTimeFormat);
                cal.add(Calendar.MINUTE, lengthTime);
                endDateTime = simpleDateFormat.format(cal.getTime());
                //查询这个时间点上班的人数
                List<StoreClassesTechnician> listClassesTechnician = storeClassesTechnicianService.getReservableTime(startDate, startTime, departmentId);
                //获取已经被预约的数量，不包括当前订单
                List<ScheduleServe> listScheduleServe;
                listScheduleServe = this.listScheduleServeNotContainOrderId(startDateTime, endDateTime, departmentId, orderId);
                if (listClassesTechnician.size() > listScheduleServe.size()) {
                    statusMap.put("status", true);
                    statusMap.put("time", startTime);
                    list.add(statusMap);
                } else {
                    statusMap.put("status", false);
                    statusMap.put("time", startTime);
                    list.add(statusMap);
                }
                cal.setTime(startDateTimeFormat);
                cal.add(Calendar.MINUTE, timeNode);
                startDateTime = simpleDateFormat.format(cal.getTime());
            }
        } catch (ParseException e) {
            e.printStackTrace();
            log.info("日期参数格式错误");
            throw new RRException("日期参数格式错误");
        }
        log.info("获取可选取日期时间列表成功：" + list);
        return list;
    }

    @Override
    public ScheduleManage queryScheduleManage(Integer id) {
        ScheduleManage scheduleManage = scheduleManageMapper.selectById(id);

        List<ScheduleServe> scheduleServeList = scheduleServeMapper.selectList(new LambdaQueryWrapper<ScheduleServe>().eq(ScheduleServe::getSchId, id));

        Set<ScheduleServe> set = new TreeSet<>(Comparator.comparing(o -> o.getSchId() + ";" + o.getServeId()));
        if (ListUtil.isNotEmpty(scheduleServeList)) {
            set.addAll(scheduleServeList);
        }
        scheduleManage.setListScheduleServer(set);
        scheduleManage.getListScheduleServer().forEach(scheduleServe -> {
            if (scheduleServe.getActualEndTime() != null && scheduleServe.getActualStartTime() != null) {
                scheduleServe.setActualServeDuration((int) (scheduleServe.getActualEndTime().getTime()
                        - scheduleServe.getActualStartTime().getTime()) / 1000 / 60);
            }
        });
        return scheduleManage;
    }

    @Override
    public IPage<ScheduleManage> queryPageScheduleManage(ScheduleManagePageQuery qry) {

        LambdaQueryWrapper<ScheduleManage> wrapper = new LambdaQueryWrapper<>();
        if (qry.getStatus() != null) {
            wrapper.eq(ScheduleManage::getStatus, qry.getStatus());
        }
        if (qry.getDepartmentId() != null) {
            wrapper.eq(ScheduleManage::getDepartmentId, qry.getDepartmentId());
        }
        if (qry.getCustomerId() != null) {
            wrapper.eq(ScheduleManage::getScheduledUser, qry.getCustomerId());
        }
        if (qry.getPhone() != null) {
            wrapper.like(ScheduleManage::getTelephone, qry.getPhone());
        }

        //已预约 服务中
        if (Lists.newArrayList(1, 8).contains(qry.getStatus())) {
            wrapper.orderByAsc(ScheduleManage::getArriveTime);
        }
        //其他
        else {
            wrapper.orderByDesc(ScheduleManage::getArriveTime);
        }

        IPage<ScheduleManage> page = new Page<>(qry.getPageNum(), qry.getPageSize());
        page = scheduleManageMapper.selectPage(page, wrapper);

        if (ListUtil.isEmpty(page.getRecords())) {
            return page;
        }

        List<ScheduleServe> scheduleServeList = scheduleServeMapper.selectList(new LambdaQueryWrapper<ScheduleServe>().in(ScheduleServe::getSchId, page.getRecords().stream().map(ScheduleManage::getId).collect(Collectors.toList())));
        Map<Integer, List<ScheduleServe>> scheduleServeMap = scheduleServeList.stream().collect(Collectors.groupingBy(ScheduleServe::getSchId));

        page.getRecords().forEach(scheduleManage -> {
            Set<ScheduleServe> set = new TreeSet<>(Comparator.comparing(o -> o.getSchId() + ";" + o.getServeId()));
            if (ListUtil.isNotEmpty(scheduleServeMap.get(scheduleManage.getId()))) {
                set.addAll(scheduleServeMap.get(scheduleManage.getId()));
            }
            scheduleManage.setListScheduleServer(set);
            scheduleManage.getListScheduleServer().forEach(scheduleServe -> {
                if (scheduleServe.getActualEndTime() != null && scheduleServe.getActualStartTime() != null) {
                    scheduleServe.setActualServeDuration((int) (scheduleServe.getActualEndTime().getTime()
                            - scheduleServe.getActualStartTime().getTime()) / 1000 / 60);
                }
            });
        });
        return page;
    }

    @Override
    public Integer getScheduledServeLeisure(Integer scheduleServeId) {
        ScheduleServe scheduleServe = scheduleServeMapper.selectById(scheduleServeId);

        LeisureDiscountConfig leisureDiscountConfig = leisureDiscountConfigMapper.selectById(scheduleServe.getLeisureDiscountConfigId());
        if (leisureDiscountConfig == null) {
            return 3;
        }
        //
        else {
            long starTime = leisureDiscountConfig.getStartTime().getTime();
            long endTime = leisureDiscountConfig.getEndTime().getTime() + 5 * 60000;
            long now = System.currentTimeMillis();
            return starTime <= now && now <= endTime ? 1 : 2;
        }
    }

    @Override
    public IPage<LeisureScheduleServe> queryPageLeisureScheduleServe(LeisureScheduleServeQuery query) {
        IPage<LeisureScheduleServe> page = new Page<>(query.getPageNum(), query.getPageSize());
        page = scheduleManageMapper.queryPageLeisureScheduleServe(page);

        page.getRecords().forEach(leisureScheduleServe -> {
            leisureScheduleServe.setDistance(MapDistance.getDistance(query.getLatitude().toString(),
                    query.getLongitude().toString(),
                    leisureScheduleServe.getLatitude().toString(),
                    leisureScheduleServe.getLongitude().toString()));
            leisureScheduleServe.setDateTime(LocalDateTime.of(leisureScheduleServe.getWeekDate(), leisureScheduleServe.getTimeNode()));
        });

        List<LeisureScheduleServe> list = page.getRecords().stream()
                .peek(leisureScheduleServe -> {
                    try {
                        leisureScheduleServe.setStoreTechnicianList(this.queryLeisureTechnician(leisureScheduleServe));
                    } catch (ParseException e) {
                        throw new RRException(e.getMessage());
                    }
                })
                .filter(leisureScheduleServe -> ListUtil.isNotEmpty(leisureScheduleServe.getStoreTechnicianList()))
                .collect(Collectors.toList());
        page.setRecords(list);
        return page;
    }

    private List<StoreTechnician> queryLeisureTechnician(LeisureScheduleServe leisureScheduleServe) throws ParseException {
        BaseServe baseServe = baseServeMapper.selectById(leisureScheduleServe.getServeId());
        LocalDateTime startTime = leisureScheduleServe.getDateTime();
        LocalDateTime endTime = startTime.plusMinutes(baseServe.getServiceDuration()).plusMinutes(60);
        List<StoreTechnician> storeTechnicianList = this.queryLeisureTechnician(leisureScheduleServe.getDepartmentId(), baseServe.getId(), startTime, endTime);
        return storeTechnicianList;
    }

    private final ProducePromotionTimeMapper producePromotionTimeMapper;

    /**
     * 参数补全
     *
     * @param cmd
     * @param defaultNodeList
     * @return
     */
    private ScheduleManage setScheduleServe(ScheduleManageCommand cmd, List<TreeProgram> defaultNodeList) {


        List<ScheduleServeCommand> scheduleServeCommandList = cmd.getScheduleServeDTOList();
        //根据defaultNodeList的参数设置服务开始时间，服务结束时间，服务美甲师
        if (ListUtil.isNotEmpty(defaultNodeList)) {
            defaultNodeList.forEach(defaultNode -> {
                scheduleServeCommandList
                        .stream()
                        //服务id或者主服务id等于defaultNode.serveId
                        .filter(scheduleServe -> defaultNode.getScheduleServeQuery().getServeId().equals(scheduleServe.getServeId())
                                || defaultNode.getScheduleServeQuery().getServeId().equals(scheduleServe.getMainServeId()))
                        .forEach(scheduleServeCommand -> {
                            ScheduleServeQuery scheduleServeQuery = defaultNode.getScheduleServeQuery();
                            StoreTechnicianPeriod storeTechnicianPeriod = defaultNode.getStoreTechnicianDTO();
                            Period schedulePeriod = scheduleServeQuery.getPeriod();

                            scheduleServeCommand.setStartTime(new Date(schedulePeriod.getStartTime()));
                            scheduleServeCommand.setEndTime(new Date(schedulePeriod.getEndTime()));
                            scheduleServeCommand.setTechnicianId(storeTechnicianPeriod.getTechnicianId());
                            scheduleServeCommand.setTechnicianIds(String.valueOf(storeTechnicianPeriod.getTechnicianId()));
                            scheduleServeCommand.setServeNumber(1);
                        });
            });
        }

        //主服务
        List<ScheduleServeCommand> mainScheduleServeCommandList = cmd.getScheduleServeDTOList()
                .stream()
                .filter(scheduleServeCommand -> scheduleServeCommand.getMainServeId() == null)
                .collect(Collectors.toList());

        //辅助服务
        List<ScheduleServeCommand> subScheduleServeCommandList = cmd.getScheduleServeDTOList()
                .stream()
                .filter(scheduleServeCommand -> scheduleServeCommand.getMainServeId() != null)
                .collect(Collectors.toList());

        //设置从服务的时间为主服务时间 因为主服务的时间已经包括的从服务的时间
        subScheduleServeCommandList
                .forEach(scheduleServeCommand -> {
                    ScheduleServeCommand mainScheduleServeCommand = mainScheduleServeCommandList.stream()
                            .filter(var -> var.getServeId().equals(scheduleServeCommand.getMainServeId()))
                            .findAny()
                            .orElseThrow(RRException::new);

                    //设置辅助服务美甲师为主服务美甲师
                    scheduleServeCommand.setTechnicianId(mainScheduleServeCommand.getTechnicianId());
                    scheduleServeCommand.setTechnicianIds(mainScheduleServeCommand.getTechnicianIds());
                    scheduleServeCommand.setStartTime(mainScheduleServeCommand.getStartTime());
                    scheduleServeCommand.setEndTime(mainScheduleServeCommand.getEndTime());
                });

        ScheduleManage scheduleManage = scheduleManageMapper.selectById(cmd.getId());
        StoreManage storeManage = storeManageMapper.selectById(cmd.getDepartmentId());

        if (scheduleManage == null) {
            scheduleManage = new ScheduleManage();
            scheduleManage.setScheduledUser(cmd.getScheduledUser());
        }
        scheduleManage.setDepartmentId(cmd.getDepartmentId());
        scheduleManage.setArriveTime(cmd.getArriveTime());
        scheduleManage.setDepartmentName(storeManage.getName());

        //设置服务店铺姓名
        //获取预约号
        String scheduleNo = this.getScheduleNo(storeManage.getId());
        scheduleManage.setScheduledNo(scheduleNo);

        Customer customer = customerService.getById(scheduleManage.getScheduledUser());

        //预约类型：小程序预约
        scheduleManage.setScheduledType(1);

        //预约用户手机号
        scheduleManage.setTelephone(customer.getPhone());

        //预约用户名如果有店员记录的名字就用店员记录的名字
        if (StringUtils.isNotEmpty(customer.getStoreRecordRealName())) {
            scheduleManage.setStoreScheduleUsername(customer.getStoreRecordRealName());
        }
        //否则就用微信昵称
        else {
            scheduleManage.setStoreScheduleUsername(customer.getNickname());
        }

        List<ScheduleServe> scheduleServeList = cmd.getScheduleServeDTOList().stream()
                .map(scheduleServeCommand -> {
                    ScheduleServe scheduleServe = scheduleServeMapper.selectById(scheduleServeCommand.getId());
                    if (scheduleServe == null) {
                        scheduleServe = new ScheduleServe();
                        scheduleServe.setCreateTime(new Date());
                        scheduleServe.setStatus(1);
                    }

                    scheduleServe.setSchId(cmd.getId());
                    //是否指定美甲师
                    scheduleServe.setIsCustomerPick(scheduleServeCommand.getIsCustomerPick());
                    //预约款式id
                    scheduleServe.setProduceId(scheduleServeCommand.getProduceId());
                    //预约服务id
                    scheduleServe.setServeId(scheduleServeCommand.getServeId());
                    //预约美甲师
                    scheduleServe.setTechnicianId(scheduleServeCommand.getTechnicianId());
                    //预约多个美甲师
                    scheduleServe.setTechnicianIds(scheduleServeCommand.getTechnicianIds());
                    //预约开始时间
                    scheduleServe.setStartTime(scheduleServeCommand.getStartTime());
                    //预约结束时间
                    scheduleServe.setEndTime(scheduleServeCommand.getEndTime());
                    //闲时折扣
                    scheduleServe.setLeisureDiscountConfigId(scheduleServeCommand.getLeisureDiscountConfigId());
                    if (scheduleServe.getLeisureDiscountConfigId() != null) {
                        LeisureDiscountConfig leisureDiscountConfig = leisureDiscountConfigMapper.selectById(scheduleServe.getLeisureDiscountConfigId());
                        scheduleServe.setDiscountRate(leisureDiscountConfig.getDiscountRate());
                    }
                    //查询服务
                    BaseServe baseServe = baseServeMapper.selectById(scheduleServe.getServeId());
                    //查询服务类型
                    BaseType baseType = baseTypeService.getById(baseServe.getTypeId());
                    //服务数量
                    scheduleServe.setServeNumber(1);
                    //服务名称
                    scheduleServe.setServeName(baseServe.getName());
                    //服务图片
                    scheduleServe.setServePicturePath(baseServe.getPicturePath());
                    //服务价格
                    scheduleServe.setServePrice(baseServe.getPrice());
                    //服务类型
                    scheduleServe.setServeType(baseType.getName());

                    scheduleServe.setServeNumber(1);
                    //如果是预约款式
                    if (scheduleServe.getProduceId() != null) {
                        BaseProduce baseProduce = baseProduceMapper.selectById(scheduleServe.getProduceId());
                        //款式名称
                        scheduleServe.setProduceName(baseProduce.getName());
                        //款式图片
                        scheduleServe.setProducePicturePath(baseProduce.getPicturePath());
                        //款式原价
                        scheduleServe.setProduceBargainPrice(baseProduce.getBargainPrice());
                        //款式现价
                        scheduleServe.setProduceCurrentPrice(baseProduce.getCurrentPrice());
                        //如果有款式就设置款式价格
                        scheduleServe.setPrice(baseProduce.getCurrentPrice());
                        //款式时间
                        scheduleServe.setLengthTime(baseProduce.getServiceDuration());

                        ProducePromotionTime producePromotionTime = producePromotionTimeMapper.selectOne(new LambdaQueryWrapper<ProducePromotionTime>().eq(ProducePromotionTime::getProduceId, scheduleServe.getProduceId()));
                        //如果款式有活动价格
                        if (producePromotionTime != null && producePromotionTime.isPromotion()) {
                            scheduleServe.setProducePromotionTimeId(producePromotionTime.getId());
                            //活动价格
                            scheduleServe.setPromotionPrice(producePromotionTime.getPrice());
                            //价格活动价格
                            scheduleServe.setPrice(producePromotionTime.getPrice());
                        }
                    }
                    //如果是预约的服务
                    else {
                        //设置价格为服务价格
                        scheduleServe.setPrice(baseServe.getPrice());
                        scheduleServe.setLengthTime(baseServe.getServiceDuration());
                    }
                    //款式做法
                    scheduleServe.setExplain(baseServe.getExplain());
                    return scheduleServe;
                })
                //多个美甲师id拆分
                .map(scheduleServe -> {
                    List<Integer> technicianIds = Lists.newArrayList(scheduleServe.getTechnicianIds().split(",")).stream().map(Integer::valueOf).collect(Collectors.toList());
                    List<ScheduleServe> list = Lists.newArrayList(scheduleServe.getTechnicianIds().split(","))
                            .stream()
                            .map(var -> {
                                ScheduleServe cloneScheduleServe = CloneUtil.deepClone(scheduleServe);
                                cloneScheduleServe.setTechnicianId(Integer.valueOf(var));
                                List<StoreTechnician> storeTechnicianList = storeTechnicianMapper.selectBatchIds(technicianIds);
                                StoreTechnician storeTechnician = storeTechnicianMapper.selectById(Integer.valueOf(var));
                                cloneScheduleServe.setTechnicianNames(storeTechnicianList.stream().map(StoreTechnician::getName).collect(Collectors.joining(",")));
                                cloneScheduleServe.setTechnicianName(storeTechnician.getName());
                                return cloneScheduleServe;
                            })
                            .collect(Collectors.toList());
                    //除了第一个 其余的id设空 防止并发请求的幂等
                    list.stream().skip(1).forEach(var -> var.setId(null));
                    return list;
                })
                .flatMap(List::stream)
                .collect(Collectors.toList());

        scheduleManage.setScheduleServeList(scheduleServeList);
        scheduleManage.addScheduleServeList(scheduleServeList);
        Set<ScheduleServe> scheduleServes = scheduleManage.getListScheduleServer();
        scheduleManage.setTotalPrice(scheduleServes.stream().map(ScheduleServe::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        return scheduleManage;
    }

    private void createOrder(ScheduleManage scheduleManage) {
        Set<ScheduleServe> scheduleServeSet = scheduleManage.getListScheduleServer();


        if (!scheduleServeSet.stream().map(ScheduleServe::getStatus).map(stats -> stats == 3 || stats == 2).collect(Collectors.toList()).contains(false)) {
            //守约
            scheduleManage.setStatus(8);
            scheduleManage.setLastUpdateTime(new Date());
            //预约的开单时间 为第一个预约的开单时间
            if (scheduleManage.getOpenbillTime() == null) {
                scheduleManage.setOpenbillTime(new Date());
            }
            scheduleManageMapper.updateById(scheduleManage);
        }

        if (!scheduleServeSet.stream().map(ScheduleServe::getStatus).map(stats -> stats == 3).collect(Collectors.toList()).contains(false)) {

            if (!scheduleManage.getStatus().equals(8) && scheduleManage.getStatus() != 3) {
                throw new RRException("重复请求");
            }

            OrderManage orderManage = OrderManage.builder()
                    //订单类型
                    .orderType(scheduleManage.getScheduledType() == 1 ? OrderManage.TYPE_CUSTOMER : OrderManage.TYPE_STORE)
                    //订单用户
                    .orderUser(scheduleManage.getScheduledUser())
                    //到店时间
                    .arriveTime(scheduleManage.getArriveTime())
                    .createTime(new Date())
                    .dataIntegrity(0.00)
                    //预约id
                    .scheduledId(scheduleManage.getId())
                    //店铺id
                    .departmentId(scheduleManage.getDepartmentId())
                    //店铺民
                    .departmentName(scheduleManage.getDepartmentName())
                    //手机号
                    .telephone(scheduleManage.getTelephone())
                    //预约客户名字
                    .storeScheduleUsername(scheduleManage.getStoreScheduleUsername())
                    //订单总改价
                    .changePrice(BigDecimal.ZERO)
                    //订单总打折价格
                    .discountPrice(BigDecimal.ZERO)
                    //订单总支付金额
                    .totalPaymentAmount(BigDecimal.ZERO)
                    //订单总金额
                    .totalPrice(BigDecimal.ZERO)
                    //创建时间
                    .launchTime(new Date())
                    //待核算
                    .status(OrderManage.STATUS_SYSTEM_UN_CHECK)
                    //订单号
                    .orderNo(this.getOrderNo(scheduleManage.getDepartmentId(), scheduleManage.getId()))
                    .build();

            List<OrderServe> orderServeList = new ArrayList<>();

            for (ScheduleServe scheduleServeVar : scheduleServeSet) {

                BigDecimal orderServePrice = scheduleServeVar.getPrice();
//                //如果是预约服务使用服务特价
//                if (scheduleServeVar.getProduceId() != null && scheduleServeVar.getProduceBargainPrice() != null) {
//                    orderServePrice = scheduleServeVar.getProduceCurrentPrice();
//                }
//                //预约款式使用款式价格
//                else {
//                    orderServePrice = scheduleServeVar.getServePrice();
//                }
//
                BaseServe baseServe = baseServeMapper.selectById(scheduleServeVar.getServeId());
                OrderServe orderServe = OrderServe.builder()
                        //服务参数
                        .technicianId(String.valueOf(scheduleServeVar.getTechnicianIds()))
                        //预约服务id
                        .serveId(scheduleServeVar.getServeId())
                        //预约服务名称
                        .serveName(scheduleServeVar.getServeName())
                        //预约服务图片
                        .servePicturePath(scheduleServeVar.getServePicturePath())
                        //预约服务数量
                        .serveNumber(1)
                        .servePrice(scheduleServeVar.getServePrice())
                        .serveType(scheduleServeVar.getServeType())
                        .serveTypeId(baseServe.getTypeId())
                        //款式参数
                        .produceBargainPrice(scheduleServeVar.getProduceBargainPrice())
                        //款式id
                        .produceId(scheduleServeVar.getProduceId())
                        //款式id
                        .produceCurrentPrice(scheduleServeVar.getProduceCurrentPrice())
                        //款式图片
                        .producePicturePath(scheduleServeVar.getProducePicturePath())
                        //款式姓名
                        .produceName(scheduleServeVar.getProduceName())
                        //美甲师姓名
                        .technicianName(scheduleServeVar.getTechnicianName())
                        //订单改价
                        .serveChangePrice(BigDecimal.ZERO)
                        //折扣金额
                        .discountPrice(BigDecimal.ZERO)
                        //评论状态未评论
                        .commentStatus(COMMENT_STATUS_NO)
                        //实际开始时间
                        .startTime(scheduleServeVar.getActualStartTime())
                        //实际结束时间
                        .endTime(scheduleServeVar.getActualEndTime())
                        //价格
                        .price(orderServePrice)
                        .producePromotionTimeId(scheduleServeVar.getProducePromotionTimeId())
                        .promotionPrice(scheduleServeVar.getPromotionPrice())
                        //业绩
                        .achievement(orderServePrice)
                        //支付金额
                        .payPrice(orderServePrice)
                        //预约时间
                        .scheduledTime(scheduleManage.getScheduledTime())

                        .build();

                if (StringUtils.isNotEmpty(scheduleServeVar.getTechnicianIds())) {
                    orderServe.setTechnicianId(scheduleServeVar.getTechnicianIds());
                }
                if (StringUtils.isNotEmpty(scheduleServeVar.getTechnicianNames())) {
                    orderServe.setTechnicianName(scheduleServeVar.getTechnicianNames());
                }

                orderManage.setTotalPaymentAmount(orderManage.getTotalPaymentAmount().add(orderServe.getPayPrice()));
                //订单服务总金额
                orderManage.setTotalPrice(orderManage.getTotalPrice().add(orderServe.getPrice()));
                //订单服务打折金额
                orderManage.setDiscountPrice(orderManage.getDiscountPrice().add(orderServe.getDiscountPrice()));
                //订单服务折扣金额
                orderManage.setChangePrice(orderManage.getChangePrice().add(orderServe.getServeChangePrice()));

                int weekday = DateUtils.getWeek(orderServe.getStartTime());

                //订单实际对应的折扣
                LeisureDiscountConfig leisureDiscountConfig = leisureDiscountConfigMapper.selectById(scheduleServeVar.getLeisureDiscountConfigId());

                if (leisureDiscountConfig != null) {
                    //折扣金额
                    BigDecimal leisureDiscountPrice = orderServe.getPrice().subtract(orderServe.getPrice().multiply(leisureDiscountConfig.getDiscountRate()));

                    //设置折扣属性
                    orderServe.setLeisureDiscountConfigId(leisureDiscountConfig.getId());
                    orderServe.setLeisureDiscountPrice(leisureDiscountPrice);
                    orderServe.setPayPrice(orderServe.getPayPrice().subtract(orderServe.getLeisureDiscountPrice()));

                    //设置订单属性
                    orderManage.setDiscountPrice(orderManage.getDiscountPrice().add(orderServe.getLeisureDiscountPrice()));
                    orderManage.setTotalPaymentAmount(orderManage.getTotalPaymentAmount().subtract(orderServe.getLeisureDiscountPrice()));

                    //更新订单实际折扣的使用次数
                    leisureDiscountConfig.setLeftTimes(leisureDiscountConfig.getLeftTimes() - 1);
                    leisureDiscountConfigMapper.updateById(leisureDiscountConfig);
                }

                //预约对应的折扣
                LeisureDiscountConfig schLeisureDiscountConfig = leisureDiscountConfigMapper.selectById(scheduleServeVar.getLeisureDiscountConfigId());

                //更新预约折扣的使用次数
                if (schLeisureDiscountConfig != null) {
                    schLeisureDiscountConfig.setLeftTimes(schLeisureDiscountConfig.getLeftTimes() + 1);
                    leisureDiscountConfigMapper.updateById(schLeisureDiscountConfig);
                }
                orderServeList.add(orderServe);
            }

            //插入订单
            orderManageMapper.insert(orderManage);
            orderServeList.forEach(orderServe -> orderServe.setOrderId(orderManage.getId()));
            //插入订单相亲
            orderServeService.saveBatch(orderServeList);

            //更新预约
            scheduleManage.setOrderId(orderManage.getId());
            scheduleManageMapper.updateById(scheduleManage);

            //设置订单sku
            orderServeList.forEach(orderServe -> {
                if (orderServe.getProduceId() != null) {

                    List<PurchaseSku> purchaseSkuList = purchaseSkuMapper.selectByProduceId(orderServe.getProduceId());

                    List<OrderServeSku> orderServeSkuList = purchaseSkuList.stream()
                            .map(purchaseSkuDTO -> OrderServeSku.builder()
                                    .type(purchaseSkuDTO.getSkuType())
                                    .skuName(purchaseSkuDTO.getSkuName())
                                    .skuId(purchaseSkuDTO.getId())
                                    .orderServeId(orderServe.getId())
                                    .build()).collect(Collectors.toList());
                    orderServeSkuService.saveBatch(orderServeSkuList);
                }
            });
            log.info("结束订单完成 orderManage:{}", orderManage);
        }

    }
}
