package com.gogirl.interfaces.common;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.common.IAgentConfigService;
import com.gogirl.domain.common.AgentConfig;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 代理规则 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-11-02
 */
@RestController
@RequestMapping("/customer/agentConfig")
public class AgentConfigController {


    @Resource
    IAgentConfigService agentConfigService;

    @ApiOperation("代理等级查询")
    @GetMapping("/agentConfigList")
    public JsonResult<List<AgentConfig>> agentConfigList() {
        List<AgentConfig> agentConfigList = agentConfigService.list(new LambdaQueryWrapper<AgentConfig>()
                .eq(AgentConfig::getIsDelete, 0));
        return JsonResult.success(agentConfigList);
    }
}
