package com.gogirl.infrastructure.service.wx;

import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.request.WxPayRefundRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.result.WxPayRefundResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import org.springframework.web.bind.annotation.RequestBody;


public interface WxPayService {

    /**
     * 调用统一下单接口，并组装生成支付所需参数对象.
     *
     * @param request 统一下单请求参数w
     * @param <T>     请使用{@link com.github.binarywang.wxpay.bean.order}包下的类
     * @return 返回 {@link com.github.binarywang.wxpay.bean.order}包下的类对象
     */
    WxPayMpOrderResult createJsapiOrder(@RequestBody WxPayUnifiedOrderRequest request) throws WxPayException;

    /**
     * 订单退款
     *
     * @param request 参数
     * @return
     * @throws WxPayException
     */
    WxPayRefundResult refund(@RequestBody WxPayRefundRequest request) throws WxPayException;

}

