package com.gogirl.infrastructure.service.sms.impl;

import com.github.qcloudsms.SmsSingleSender;
import com.github.qcloudsms.SmsSingleSenderResult;
import com.gogirl.infrastructure.service.sms.SmsService;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONException;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.xml.ws.http.HTTPException;
import java.io.IOException;

/**
 * 短信服务 腾讯云短信实现
 */
@Service
@Slf4j
public class QCloudSmsServiceImpl implements SmsService {
    @Resource
    StringRedisTemplate stringRedisTemplate;

    @Override
    public SmsSingleSenderResult sendBindSmsCode(String phoneNumber, String code) {
        //
        String smsSign = SmsConstant.smsSign;
        int templateId = SmsConstant.bindTemplateId;
        String[] params = {code, SmsConstant.activeTime};

        SmsSingleSenderResult result = new SmsSingleSenderResult();

        try {
            SmsSingleSender sender = new SmsSingleSender(SmsConstant.appid, SmsConstant.appkey);
            result = sender.sendWithParam("86", phoneNumber, templateId, params, smsSign, "", "");
            stringRedisTemplate.opsForValue().set(phoneNumber, code);

        }
        // HTTP响应码错误 json解析错误 网络IO错误
        catch (HTTPException | JSONException | IOException | com.github.qcloudsms.httpclient.HTTPException e) {
            log.error(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public Boolean checkSmsCode(String phoneNumber, String code) {
        return code.equals(stringRedisTemplate.opsForValue().get(phoneNumber));
    }

}
