package com.gogirl.infrastructure.mapper.order.mall;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.domain.order.mall.MallOrderTechnician;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.shared.order.mall.QueryMallOrderAchievementRequest;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 商城订单  - 美甲师 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-06-22
 */
public interface MallOrderTechnicianMapper extends BaseMapper<MallOrderTechnician> {

    /**
     * 根据订单id获取订单推荐美甲师
     *
     * @param mallOrderId
     * @return
     */
    List<StoreTechnician> selectTechnicianList(Long mallOrderId);

    /**
     * 查询美甲师业绩列表
     *
     * @param page
     * @param param
     * @return
     */
    Page<MallOrderTechnician> queryMallOrderAchievement(@Param("page") Page<Object> page, @Param("param") QueryMallOrderAchievementRequest param);

    /**
     * 查询总业绩
     *
     * @param technicianId
     * @param departmentId
     * @param date
     * @return
     */
    BigDecimal queryTotalMallOrderAchievement(@Param("technicianId") Integer technicianId, @Param("departmentId") Integer departmentId, @Param("date") String date);
}
