package com.gogirl.infrastructure.common.interceptor;

import lombok.AllArgsConstructor;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

/**
 * <p>
 * spring mvc拦截器配置
 * </p>
 *
 * @author robbendev
 */
@Configuration
@AllArgsConstructor
public class MvcInterceptorConfig extends WebMvcConfigurationSupport {

    private final LoginHandlerInterceptor loginHandlerInterceptor;
    private final SessionHandlerInterceptor sessionHandlerInterceptor;
    private final AuthHandlerInterceptor authHandlerInterceptor;

    @Override
    protected void addInterceptors(InterceptorRegistry registry) {

        registry.addInterceptor(loginHandlerInterceptor)
                .addPathPatterns("/**")
                .excludePathPatterns("/swagger-resources/**", "/webjars/**", "/v2/**", "/swagger-ui.html/**", "/error")
                .excludePathPatterns("/doc.html")
                .excludePathPatterns("/csrf")
        ;

        registry.addInterceptor(sessionHandlerInterceptor);
        registry.addInterceptor(authHandlerInterceptor)
                .addPathPatterns("/**")
                .excludePathPatterns("/swagger-resources/**", "/webjars/**", "/v2/**", "/swagger-ui.html/**", "/error")
                .excludePathPatterns("/doc.html")
                .excludePathPatterns("/csrf")
        ;

        super.addInterceptors(registry);
    }


    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {

        //swagger增加url映射
        registry.addResourceHandler("/swagger-ui.html")
                .addResourceLocations("classpath:/META-INF/resources/");

        registry.addResourceHandler("/webjars/**")
                .addResourceLocations("classpath:/META-INF/resources/webjars/");

        registry.addResourceHandler("/doc.html")
                .addResourceLocations("classpath:/META-INF/resources/");
        registry.addResourceHandler("/webjars/**")
                .addResourceLocations("classpath:/META-INF/resources/webjars/");
    }


}


