package com.gogirl.domain.user.customer;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.store.store.StoreUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@ApiModel("会员卡")
@AllArgsConstructor
@Builder
@TableName("customer_balance")
@Data
public class CustomerBalance implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("顾客id")
    private Integer customerId;

    @ApiModelProperty("余额")
    private Integer balance;

    @ApiModelProperty("折扣")
    private Double currentDiscount;

    @ApiModelProperty("首次充值时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date firstChargeTime;

    @ApiModelProperty("最后一次更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @ApiModelProperty("总充值金额")
    private Integer totalCharge;

    @ApiModelProperty("总送金额")
    private Integer totalBestow;

    @ApiModelProperty("总花费金额")
    private Integer totalExpenditure;

    @Version
    private Integer version;

    @ApiModelProperty("会员级别 ")
    private String level;

    @ApiModelProperty("推荐人")
    private String refereeId;

    @ApiModelProperty("折扣百分比")
    private Double discountRate;

    @ApiModelProperty("顾客id")
    @TableField(exist = false)
    private StoreUser referee;

    public CustomerBalance(Integer customerId,
                           Integer balance,
                           Date firstChargeTime,
                           Date updateTime,
                           Integer totalCharge,
                           Integer totalExpenditure,
                           Integer version,
                           Double currentDiscount,
                           Integer totalBestow, String level) {
        super();
        this.customerId = customerId;
        this.balance = balance;
        this.firstChargeTime = firstChargeTime;
        this.updateTime = updateTime;
        this.totalCharge = totalCharge;
        this.totalExpenditure = totalExpenditure;
        this.version = version;
        this.currentDiscount = currentDiscount;
        this.totalBestow = totalBestow;
        this.level = level;

    }

    public CustomerBalance() {

    }

    public static CustomerBalance getInstance(Integer customerId) {
        //新建会员卡
        CustomerBalance customerBalance = CustomerBalance.builder()
                .balance(0)
                .customerId(customerId)
                .currentDiscount(1.00)
                .discountRate(1.00)
                .firstChargeTime(new Date())
                .level("普通会员")
                .totalBestow(0)
                .totalCharge(0)
                .totalExpenditure(0)
                .version(1)
                .updateTime(new Date())
                .build();
        return customerBalance;
    }
}
