package com.gogirl.domain.product.serve;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


@ApiModel("服务类型")
@Data
@TableName("base_type")
public class BaseType implements Serializable {

    private Integer id;

    @ApiModelProperty("服务名称")
    private String name;

    @ApiModelProperty("创建用户")
    private String createUser;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @ApiModelProperty("服务英文名")
    private String enName;

    @ApiModelProperty("服务短码")
    private String shortCode;

    private Integer sorts;
}

