package com.gogirl.infrastructure.mapper.product.purchase;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gogirl.domain.product.purchase.PurchaseSku;
import com.gogirl.shared.product.PurchaseSkuPOI;

import java.util.List;


public interface PurchaseSkuMapper extends BaseMapper<PurchaseSku> {

    /**
     * 根据分类查询产品sku列表
     *
     * @param purchaseSkuIPage
     * @param mallCategoryId
     * @return
     */
    IPage<PurchaseSku> queryPagePurchaseSku(IPage<PurchaseSku> purchaseSkuIPage, Long mallCategoryId);

    /**
     * 根据名称查找sku
     *
     * @param skuName
     * @return
     */
    PurchaseSku selectBySkuName(String skuName);

    /**
     * @param produceId
     * @return
     */
    List<PurchaseSku> selectByProduceId(Integer produceId);


    /**
     *
     * @return
     */
    List<PurchaseSkuPOI> purchaseSkuExcel();


    /**
     * 获取款式id对应的采购sku
     * @param list
     * @return
     */
    List<PurchaseSku> listByProduceIds(List<Integer> list);
}
