package com.gogirl.domain.product.serve;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.gogirl.domain.product.purchase.PurchaseSku;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


/**
 * Created by yinyong on 2018/8/20.
 * 款式
 */
@ApiModel("款式")
@Data

@TableName("base_produce")
public class BaseProduce implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("服务id")
    private Integer serviceId;

    @ApiModelProperty("款式标签id")
    private Integer produceLabelId;

    @ApiModelProperty("款式名称")
    private String name;

    @ApiModelProperty("图片")
    private String picturePath;
    ;
    @ApiModelProperty("1-上线 2-下线")
    private String status;

    @ApiModelProperty("描述")
    private String details;

    @ApiModelProperty("点赞总次数")
    private Integer praiseSum;

    @ApiModelProperty("现价")
    private BigDecimal currentPrice;

    @ApiModelProperty("原价")
    private BigDecimal bargainPrice;

    @ApiModelProperty("服务简介")
    private String briefIntroduction;

    @ApiModelProperty("子标题")
    private String subTitle;

    @ApiModelProperty("服务市场")
    private Integer serviceDuration;

    @TableField(exist = false)
    private PraiseRecord praiseRecord;

    @TableField(exist = false)
    private BaseServe serve;

    @TableField(exist = false)
    private String serveName;

    @TableField(exist = false)
    private BigDecimal price;

    @ApiModelProperty("款式销量 定时任务统计")
    private Integer salesNum;

    private Integer serveTypeId;

    @TableField(exist = false)
    private BigDecimal promotionPrice;

    private String practice;

    private Integer isWorkTpl;

    @TableField(exist = false)
    private List<PurchaseSku> purchaseSkuList;
}
