package com.gogirl.application.product.serve.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.serve.BaseProduceService;
import com.gogirl.application.product.serve.IBaseProduceSubjectService;
import com.gogirl.application.product.serve.IProduceStorePriceService;
import com.gogirl.domain.product.serve.BaseFeatures;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.domain.product.serve.BaseProduceSubject;
import com.gogirl.domain.product.serve.PraiseRecord;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.infrastructure.mapper.product.serve.BaseFeaturesMapper;
import com.gogirl.infrastructure.mapper.product.serve.BaseProduceMapper;
import com.gogirl.infrastructure.mapper.product.serve.PraiseRecordMapper;
import com.gogirl.shared.product.serve.QueryProducePageRequest;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@Service
@AllArgsConstructor
public class BaseProduceServiceImpl extends ServiceImpl<BaseProduceMapper, BaseProduce> implements BaseProduceService {

    private final BaseProduceMapper baseProduceMapper;
    private final BaseFeaturesMapper baseFeaturesMapper;
    private final IProduceStorePriceService produceStorePriceService;
    private final IBaseProduceSubjectService baseProduceSubjectService;

    @Override
    public BaseProduce getProduceForDetail(Integer id) {
        BaseProduce baseProduce = baseProduceMapper.getProduceForDetail(id);
        BaseProduceSubject baseProduceSubject = baseProduceSubjectService.getById(baseProduce.getSubjectId());
        baseProduce.setBaseProduceSubject(baseProduceSubject);
        produceStorePriceService.setProduceStorePrice(baseProduce);
        return baseProduce;
    }

    @Override
    public IPage<BaseProduce> queryProducePage(QueryProducePageRequest request) {

        BaseFeatures baseFeatures = baseFeaturesMapper.selectById(request.getLabelId());
        IPage<BaseProduce> page = new Page<>(request.getPageNum(), request.getPageSize());

        //排序条件 1-saleNum 2-index_sort
        Integer sort = baseFeatures != null && baseFeatures.getName().equals("热销款") ? 1 : 2;
        request.setSort(sort);
        request.setSourceFrom(SessionUtils.getSourceFrom());
        Integer departmentId = SessionUtils.getDepartmentId();
        request.setDepartmentId(departmentId);

        page = baseProduceMapper.queryProducePage(page, request);

        List<Integer> produceIds = page.getRecords().stream().map(BaseProduce::getId).collect(Collectors.toList());

        LambdaQueryWrapper<PraiseRecord> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(PraiseRecord::getServeId, produceIds)
                .eq(PraiseRecord::getType, 2);
        if (SessionUtils.getCustomerToken() != null) {
            wrapper.eq(PraiseRecord::getCustomerId, SessionUtils.getCustomerId());
        }
        wrapper.eq(PraiseRecord::getBrandId, request.getBrandId());
        List<PraiseRecord> praiseRecordList = praiseRecordMapper.selectList(wrapper);
        Map<Integer, List<PraiseRecord>> map = praiseRecordList.stream().collect(Collectors.groupingBy(PraiseRecord::getServeId));
        page.getRecords().forEach(baseProduce -> {
            List<PraiseRecord> mapPraiseRecordList = map.get(baseProduce.getId());
            if (ListUtil.isNotEmpty(mapPraiseRecordList)) {
                baseProduce.setPraiseRecord(mapPraiseRecordList.stream().findAny().orElse(null));
            }
        });

        produceStorePriceService.setProduceStorePrice(page.getRecords());
        return page;
    }

    private final PraiseRecordMapper praiseRecordMapper;

    @Override
    public void praiseProduce(Integer produceId) {

        BaseProduce baseProduce = this.getById(produceId);
        if (baseProduce == null) {
            throw new RRException("款式不存在");
        }
        Integer praiseSum = baseProduce.getPraiseSum();
        if (praiseSum == null) {
            praiseSum = 0;
        }

        //查看用户有没有点赞过，如果有，取消点赞，如果没有，点赞
        PraiseRecord praiseRecord = praiseRecordMapper.selectOne(new LambdaQueryWrapper<PraiseRecord>()
                .eq(PraiseRecord::getCustomerId, SessionUtils.getCustomerId())
                .eq(PraiseRecord::getServeId, produceId)
                .eq(PraiseRecord::getType, 2));

        //点赞
        if (praiseRecord == null) {
            baseProduce.setPraiseSum(++praiseSum);
            this.updateById(baseProduce);

            praiseRecord = new PraiseRecord();
            praiseRecord.setCustomerId(SessionUtils.getCustomerId());
            praiseRecord.setServeId(produceId);
            praiseRecord.setTime(new Date());
            //1.服务;2.款式type
            praiseRecord.setType(2);
            praiseRecord.setBrandId(baseProduce.getBrandId());
            praiseRecordMapper.insert(praiseRecord);
        }
        //取消点赞
        else {
            baseProduce.setPraiseSum(--praiseSum);
            this.updateById(baseProduce);
            praiseRecordMapper.deleteById(praiseRecord.getId());
        }
    }
}
