package com.gogirl.application.product.serve.impl;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.serve.BaseServeService;
import com.gogirl.domain.market.discount.LeisureDiscountConfig;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.infrastructure.mapper.market.discount.LeisureDiscountConfigMapper;
import com.gogirl.infrastructure.mapper.product.serve.BaseServeMapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

@Service
@AllArgsConstructor
public class BaseServeServiceImpl extends ServiceImpl<BaseServeMapper, BaseServe> implements BaseServeService {

    private final BaseServeMapper baseServeMapper;
    private final LeisureDiscountConfigMapper leisureDiscountConfigMapper;


    @Override
    public List<BaseServe> listServeForPage(BaseServe param, List<Integer> serveIdList) {
        return baseServeMapper.listServeForPage(param, serveIdList);
    }

    @Override
    public BaseServe getAggregate(Integer id, LocalDateTime date, Integer departmentId) {
        BaseServe baseServe = baseServeMapper.getAggregate(id);
        if (date != null) {
            LeisureDiscountConfig leisureDiscountConfig = leisureDiscountConfigMapper.selectLeisureDiscount(id,
                    date.toLocalTime().toString(),
                    date.getDayOfWeek().getValue(),
                    departmentId);
            if (leisureDiscountConfig != null)
                baseServe.setDiscountRate(leisureDiscountConfig.getDiscountRate());
        }
        return baseServe;
    }
}
