package com.gogirl.infrastructure.common.aspect;//package com.gogirl.infrastructure.common.aspect;
//
//import com.alibaba.fastjson.JSON;
//import lombok.extern.slf4j.Slf4j;
//import org.aspectj.lang.JoinPoint;
//import org.aspectj.lang.annotation.*;
//import org.springframework.context.annotation.Configuration;
//
//import java.util.Arrays;
//
//@Aspect
//@Configuration
//@Slf4j
//public class LogAspect {
//
//
//    /**
//     * Controller层切点
//     */
//    @Pointcut("@annotation(com.xxxx.utils.logs.annotation.ControllerLogs)")
//    public void controllerAspect() {
//
//    }
//
//    /**
//     * 前置通知 用于拦截Controller层记录用户的操作
//     *
//     * @param joinPoint 切点
//     */
//    @Before("controllerAspect()")
//    public void doBefore(JoinPoint joinPoint) {
//        try {
//            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
//            //类名
//            String className = joinPoint.getTarget().getClass().getName();
//            //请求方法
//            String method = joinPoint.getSignature().getName() + "()";
//            //方法参数
//            String methodParam = JSON.toJSONString(joinPoint.getArgs());
//            //方法描述
//            String methodDescription = getControllerMethodDescription(joinPoint);
//            StringBuilder sb = new StringBuilder(1000);
//            sb.append("\n");
//            sb.append("*********************************Request请求***************************************");
//            sb.append("\n");
//            sb.append("ClassName     :  ").append(className).append("\n");
//            sb.append("RequestMethod :  ").append(method).append("\n");
//            sb.append("RequestParams :  ").append(methodParam).append("\n");
//            sb.append("RequestType   :  ").append(request.getMethod()).append("\n");
//            sb.append("Description   :  ").append(methodDescription).append("\n");
//            sb.append("serverAddr    :  ").append(request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort()).append("\n");
//            sb.append("RemoteAddr    :  ").append(IpUtils.getRemoteAddr(request)).append("\n");
//            UserAgent userAgent = UserAgentUtils.getUserAgent(request);
//            sb.append("DeviceName    :  ").append(userAgent.getOperatingSystem().getName()).append("\n");
//            sb.append("BrowserName   :  ").append(userAgent.getBrowser().getName()).append("\n");
//            sb.append("UserAgent     :  ").append(request.getHeader("User-Agent")).append("\n");
//            sb.append("RequestUri    :  ").append(StringUtils.abbr(request.getRequestURI(), 255)).append("\n");
//            log.info(sb.toString());
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//    }
//
//    @AfterReturning(returning = "ret", pointcut = "controllerAspect()")
//    public void doAfterReturning(Object ret) throws Throwable {
//        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
//        //请求方法
//        String method = StringUtils.abbr(request.getRequestURI(), 255);
//        StringBuilder sb = new StringBuilder(1000);
//        // 处理完请求，返回内容
//        sb.append("\n");
//        sb.append("Result        :  ").append(ret);
//        log.info(sb.toString());
//    }
//
//
//    /**
//     * 异常通知 用于拦截service层记录异常日志
//     *
//     * @param joinPoint
//     * @param ex
//     */
//    @AfterThrowing(pointcut = "serviceAspect()", throwing = "ex")
//    public void doAfterThrowing(JoinPoint joinPoint, Throwable ex) {
//        try {
//            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
//            //类名
//            String className = joinPoint.getTarget().getClass().getName();
//            //请求方法
//            String method = (joinPoint.getTarget().getClass().getName() + "." + joinPoint.getSignature().getName() + "()");
//            //方法参数
//            String methodParam = Arrays.toString(joinPoint.getArgs());
//            //方法描述
//            String methodDescription = getServiceMthodDescription(joinPoint);
//            //获取用户请求方法的参数并序列化为JSON格式字符串
//            String params = "";
//            if (joinPoint.getArgs() != null && joinPoint.getArgs().length > 0) {
//                for (int i = 0; i < joinPoint.getArgs().length; i++) {
//                    params += JSON.toJSONString(joinPoint.getArgs()[i]) + ";";
//                }
//            }
//            StringBuilder sb = new StringBuilder(1000);
//            sb.append("\n");
//            sb.append("*********************************Service异常***************************************");
//            sb.append("\n");
//            sb.append("ClassName        :  ").append(className).append("\n");
//            sb.append("Method           :  ").append(method).append("\n");
//            sb.append("Params           :  ").append("[" + params + "]").append("\n");
//            sb.append("Description      :  ").append(methodDescription).append("\n");
//            sb.append("ExceptionName    :  ").append(ex.getClass().getName()).append("\n");
//            sb.append("ExceptionMessage :  ").append(ex.getMessage()).append("\n");
//            log.info(sb.toString());
//        } catch (Exception e1) {
//            e1.printStackTrace();
//        }
//    }
//
//    /**
//     * 获取注解中对方法的描述信息 用于service层注解
//     *
//     * @param joinPoint 切点
//     * @return 方法描述
//     * @throws Exception
//     */
//    public static String getServiceMthodDescription(JoinPoint joinPoint)
//            throws Exception {
//        String targetName = joinPoint.getTarget().getClass().getName();
//        String methodName = joinPoint.getSignature().getName();
//        Object[] arguments = joinPoint.getArgs();
//        Class targetClass = Class.forName(targetName);
//        Method[] methods = targetClass.getMethods();
//        String description = "";
//        for (Method method : methods) {
//            if (method.getName().equals(methodName)) {
//                Class[] clazzs = method.getParameterTypes();
//                if (clazzs.length == arguments.length) {
//                    description = method.getAnnotation(ServiceLogs.class).description();
//                    break;
//                }
//            }
//        }
//        return description;
//    }
//
//    /**
//     * 获取注解中对方法的描述信息 用于Controller层注解
//     *
//     * @param joinPoint 切点
//     * @return 方法描述
//     * @throws Exception
//     */
//    public static String getControllerMethodDescription(JoinPoint joinPoint) throws Exception {
//        String targetName = joinPoint.getTarget().getClass().getName();
//        String methodName = joinPoint.getSignature().getName();
//        Object[] arguments = joinPoint.getArgs();
//        Class targetClass = Class.forName(targetName);
//        Method[] methods = targetClass.getMethods();
//        String description = "";
//        for (Method method : methods) {
//            if (method.getName().equals(methodName)) {
//                Class[] clazzs = method.getParameterTypes();
//                if (clazzs.length == arguments.length) {
//                    description = method.getAnnotation(ControllerLogs.class).description();
//                    break;
//                }
//            }
//        }
//        return description;
//    }
//
//
//}
