package com.gogirl.interfaces.dashboard;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.store.store.StoreManageService;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.feign.AdminFeign;
import com.gogirl.shared.admin.AdminPage;
import com.gogirl.shared.admin.dashboard.req.*;
import com.gogirl.shared.admin.dashboard.resp.GetStoreTrendApiResp;
import com.gogirl.shared.admin.techcnian.AchievementsPersonaResult;
import com.gogirl.shared.admin.techcnian.AchievementsPersonaResultPageApiRequest;
import com.gogirl.shared.admin.techcnian.AdminTechnicianScoreResp;
import com.gogirl.shared.admin.techcnian.GetTechnicianPageRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/8/17 9:09 上午
 */
@Api(tags = "4.0报表")
@RestController
@RequestMapping("/technician/dashboard")
public class DashboardController {
    @Resource
    AdminFeign adminFeign;

    @ApiOperation("见doc文档getStoreTrendApi")
    @PostMapping("/no_getStoreTrendApi")
    public JsonResult<GetStoreTrendApiResp> getStoreTrendApi(@RequestBody GetStoreTrendApiRequest request) {
        return JsonResult.success(adminFeign.getStoreTrendApi(request).getData());
    }

    @ApiOperation("见doc文档getStoreListApi")
    @PostMapping("/no_getStoreListApi")
    public JsonResult<List<Map<String, Object>>> getStoreListApi(@RequestBody GetStoreListApiRequest request) {
        return JsonResult.success(adminFeign.getStoreListApi(request).getData());

    }

    @ApiOperation("见doc文档preStorageSumApi")
    @PostMapping("/no_preStorageSumApi")
    public JsonResult<Map<String, Object>> preStorageSumApi(@RequestBody PreStorageSumApiRequest request) {
        return JsonResult.success(adminFeign.preStorageSumApi(request).getData());

    }


    @ApiOperation("no_revenueSumByTypeApi")
    @PostMapping(value = "/api/Report/revenueSumByTypeApi")
    public JsonResult<Map<String, Object>> revenueSumByTypeApi(@RequestBody RevenueSumByTypeApiRequest request) {
        return JsonResult.success(adminFeign.revenueSumByTypeApi(request).getData());
    }


    @ApiOperation("见doc文档revenueTypeListApi")
    @PostMapping("/no_revenueTypeListApi")
    public JsonResult<List<Map<String, Object>>> revenueTypeListApi(@RequestBody RevenueTypeListRequest request) {
        return JsonResult.success(adminFeign.revenueTypeListApi(request).getData());

    }

    @Resource
    StoreManageService storeManageService;

    @ApiOperation("见doc文档revenueSumApi")
    @PostMapping("/no_revenueSumApi")
    public JsonResult<List<Map<String, Object>>> revenueSumApi(@RequestBody RevenueSumApiRequest request) {
        List<Map<String, Object>> data = adminFeign.revenueSumApi(request).getData();
        data.forEach(stringObjectMap -> {
            String storeName = String.valueOf(stringObjectMap.get("store_name"));
            StoreManage storeManage = storeManageService.getOne(new LambdaQueryWrapper<StoreManage>()
                    .eq(StoreManage::getName, storeName));
            stringObjectMap.put("departmentId", storeManage == null ? 0 : storeManage.getId());
        });
        return JsonResult.success(data);
    }


    @ApiOperation("美甲师信息")
    @PostMapping("/no_getTechnicianPage")
    public JsonResult<AdminPage<AdminTechnicianScoreResp>> getTechnicianPage(@RequestBody GetTechnicianPageRequest request) {
        return JsonResult.success(adminFeign.getTechnicianPage(request).getData());
    }


    @ApiOperation("美甲师业绩")
    @PostMapping("/no_achievementsPersonaResultPageApi")
    public JsonResult<AdminPage<AchievementsPersonaResult>> achievementsPersonaResultPageApi(@RequestBody AchievementsPersonaResultPageApiRequest request) {
        return JsonResult.success(adminFeign.achievementsPersonaResultPageApi(request).getData());
    }


    @ApiOperation("1级/2级/3级 sku")
    @PostMapping("/no_revenueServiceListApi")
    public JsonResult<List<Map<String, Object>>> revenueServiceListApi(@RequestBody RevenueServiceListApiRequest request) {
        return JsonResult.success(adminFeign.revenueServiceListApi(request).getData());
    }
}
