package com.gogirl.application.user.customer.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.user.customer.CustomerBalanceService;
import com.gogirl.domain.market.coupon.CouponCustomerRelevance;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.infrastructure.mapper.market.coupon.CouponCustomerRelevanceMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderManageMapper;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/12 6:01 下午
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@ActiveProfiles("prod")
public class CustomerBalanceServiceImplTest {

    @Resource
    CustomerBalanceService customerBalanceService;
    @Resource
    OrderManageMapper orderManageMapper;
    @Resource
    CouponCustomerRelevanceMapper couponCustomerRelevanceMapper;

    @org.junit.Test
    public void transferBalance() {
        customerBalanceService.transferBalance("18520777497", "18312033388");
    }

    //s撤回带核算
    @org.junit.Test
    public void order() {
        List<OrderManage> orderManageList = orderManageMapper.selectList(new LambdaQueryWrapper<OrderManage>()
                .in(OrderManage::getOrderNo, Lists.newArrayList("BTD-GZJ-NNN-210223-0021")));
        orderManageList.forEach(orderManage -> {
            if (orderManage.getStatus().equals(2)) {
                orderManage.setStatus(11);
                orderManageMapper.updateById(orderManage);

                List<CouponCustomerRelevance> couponCustomerRelevanceList = couponCustomerRelevanceMapper.selectList(new LambdaQueryWrapper<CouponCustomerRelevance>()
                        .eq(CouponCustomerRelevance::getOrderId, orderManage.getId()));
                couponCustomerRelevanceList.forEach(couponCustomerRelevance -> {
                    couponCustomerRelevance.setOrderId(null);
                    couponCustomerRelevanceMapper.updateById(couponCustomerRelevance);
                });
            } else {
                log.error("invalid status");
            }

        });
    }
}
