package com.gogirl.infrastructure.common.interceptor;

import com.gogirl.application.common.xcx.GogirlTokenService;
import com.gogirl.domain.common.xcx.GogirlToken;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.infrastructure.common.util.StringUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Component
@AllArgsConstructor
@Slf4j
public class SessionHandlerInterceptor implements HandlerInterceptor {

    private final GogirlTokenService gogirlTokenService;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {

        String token = request.getHeader("token");
        String sourceFrom = request.getHeader("sourceFrom");
        String departmentId = request.getHeader("customerDepartmentId");

        SessionUtils.putSourceFrom(sourceFrom);
        SessionUtils.putCustomerDepartmentId(departmentId);

        if (StringUtils.isNotEmpty(sourceFrom) && sourceFrom.equals("customer")) {
            GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
            if (gogirlToken != null) {
                SessionUtils.putCustomerToken(gogirlToken);
            }
            HandlerMethod h = (HandlerMethod) handler;
        }

        if (StringUtils.isNotEmpty(sourceFrom) && sourceFrom.equals("technician")) {
            GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
            if (gogirlToken != null) {
                SessionUtils.putTechnicianToken(gogirlToken);
            }
        }
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        SessionUtils.removeCustomerToken();
        SessionUtils.removeTechnicianToken();
        SessionUtils.removeSourceFrom();
        SessionUtils.removeCustomerDepartmentId();
    }

}
