package com.gogirl.application.store.store.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.store.store.StoreClassesService;
import com.gogirl.application.store.store.StoreClassesTechnicianService;
import com.gogirl.domain.store.store.StoreClasses;
import com.gogirl.domain.store.store.StoreClassesTechnician;
import com.gogirl.infrastructure.mapper.store.store.StoreClassesMapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@AllArgsConstructor
public class StoreClassesServiceImpl extends ServiceImpl<StoreClassesMapper, StoreClasses> implements StoreClassesService {

    private final StoreClassesTechnicianService storeClassesTechnicianService;

    @Override
    public List<StoreClassesTechnician> queryMonthClasses(Integer technicianId, Integer departmentId, String month) {
        List<StoreClasses> classList = this.list(new LambdaQueryWrapper<StoreClasses>()
                .eq(StoreClasses::getDepartmentId, departmentId));

        Map<Integer, StoreClasses> classesMap = classList.stream().collect(Collectors.toMap(StoreClasses::getId, storeClasses -> storeClasses));

        List<StoreClassesTechnician> lists = storeClassesTechnicianService.listClassesTechnicianDetail(technicianId, month);
        lists.forEach(item -> item.setClassesManage(classesMap.get(item.getClasses())));
        return lists;
    }
}
