package com.gogirl.domain.order.serve;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.domain.store.store.StoreTechnician;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by yinyong on 2018/10/7.
 */
@ApiModel("预约每一次的修改记录")
@Data
@TableName("scheduled_update_record")
public class ScheduleUpdateRecord implements Serializable {

    @TableId(type = IdType.AUTO)
    @ApiModelProperty("修改记录id")
    private Integer id;

    @ApiModelProperty("预约id")
    private Integer schId;

    @ApiModelProperty("预约美甲师")
    private Integer technicianId;


    @ApiModelProperty("预约服务 ID")
    private Integer serveId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("开始时间")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("结束时间")
    private Date endTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("样式名称")
    private String produceName;

    @ApiModelProperty("服务数量默认1")
    private Integer serveNumber;

    @ApiModelProperty("0#修改 1#增加 2#删除 3#原始数据")
    private Integer type;

    /**
     * 非数据库字段
     */
    @TableField(exist = false)
    @ApiModelProperty("服务实体对象")
    private BaseServe baseServe;

    @TableField(exist = false)
    @ApiModelProperty("美甲师对象")
    private StoreTechnician storeTechnician;


}
