package com.gogirl.interfaces.store.career;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.store.store.CareerCmdService;
import com.gogirl.application.store.store.StoreDataService;
import com.gogirl.domain.order.serve.OrderServe;
import com.gogirl.domain.store.career.Career;
import com.gogirl.domain.store.store.StoreData;
import com.gogirl.domain.store.store.TechnicianAchieve;
import com.gogirl.domain.store.training.SkillSku;
import com.gogirl.domain.store.training.TechnicianScore;
import com.gogirl.domain.user.customer.CustomerBalanceRecord;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.infrastructure.mapper.order.serve.OrderServeMapper;
import com.gogirl.infrastructure.mapper.store.store.TechnicianScoreMapper;
import com.gogirl.infrastructure.mapper.store.training.SkillSkuMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerBalanceRecordMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 美甲师职业生涯接口
 */
@Api(tags = "美甲师职业生涯接口", value = "美甲师职业生涯接口")
@RestController
@AllArgsConstructor
public class CareerController {


    private final TechnicianScoreMapper technicianScoreMapper;
    private final SkillSkuMapper skillSkuMapper;


    private final CareerCmdService careerCmdService;
    private final OrderServeMapper orderServeMapper;
    private final CustomerBalanceRecordMapper customerBalanceRecordMapper;


    @ApiOperation("成长历程")
    @GetMapping("/technician/career/career")
    public JsonResult<Career> career() {
        Career career = careerCmdService.career(SessionUtils.getTechnicianId());
        return JsonResult.success(career);
    }

    private final StoreDataService storeDataService;

    @ApiOperation("门店数据")
    @GetMapping("/technician/career/storeData")
    public JsonResult<StoreData> storeData(@RequestParam String month) {
        StoreData storeData = storeDataService.storeData(month);
        return JsonResult.success(storeData);
    }

    @ApiOperation("分页查询订单业绩")
    @GetMapping("/technician/career/queryPageAchieve")
    public JsonResult<Page<OrderServe>> queryPageAchieve(@RequestParam String type,
                                                         @RequestParam Integer pageNum,
                                                         @RequestParam Integer pageSize,
                                                         @RequestParam(required = false) String month) {

        Page<OrderServe> page = new Page<>(pageNum, pageSize);
        Integer technicianId = SessionUtils.getTechnicianId();
        Page<OrderServe> result = orderServeMapper.queryPageAchieve(page, technicianId, type, month);
        return JsonResult.success(result);
    }

    @ApiOperation("分页查询订单业绩")
    @GetMapping("/technician/career/queryPageTechnicianAchieve")
    public JsonResult<Page<TechnicianAchieve>> queryPageTechnicianAchieve(@RequestParam String type,
                                                                          @RequestParam Integer pageNum,
                                                                          @RequestParam Integer pageSize,
                                                                          @RequestParam(required = false) String month,
                                                                          @RequestParam(required = false) Integer technicianId,
                                                                          @RequestHeader("brandId") Integer brandId) {

        Page<OrderServe> page = new Page<>(pageNum, pageSize);

        Integer departmentId = SessionUtils.getTechnicianToken().getDepartmentId();
        if (type.equals("开卡")) {
            Page<TechnicianAchieve> result = orderServeMapper.queryPageChargeTechnicianAchieve(page, technicianId, month, departmentId, brandId);
            return JsonResult.success(result);
        } else {
            Page<TechnicianAchieve> result = orderServeMapper.queryPageOrderTechnicianAchieve(page, technicianId, type, month, departmentId, brandId);
            return JsonResult.success(result);
        }
    }

    @ApiOperation("分页查询开卡业绩")
    @GetMapping("/technician/career/queryPageChargeAchieve")
    public JsonResult<Page<CustomerBalanceRecord>> queryPageChargeAchieve(@RequestParam Integer pageNum,
                                                                          @RequestParam Integer pageSize,
                                                                          @RequestParam(required = false) String month) {

        Page<CustomerBalanceRecord> page = new Page<>(pageNum, pageSize);
        Integer technicianId = SessionUtils.getTechnicianId();
        Page<CustomerBalanceRecord> result = customerBalanceRecordMapper.queryPageAchieve(page, technicianId, month);
        return JsonResult.success(result);
    }

    @ApiOperation("查询美甲师评分")
    @GetMapping("/technician/career/queryPageTechScore")
    public JsonResult<List<TechnicianScore>> queryPageTechScore() {

        Integer technicianId = SessionUtils.getTechnicianId();

        List<TechnicianScore> list = technicianScoreMapper.selectList(new LambdaQueryWrapper<TechnicianScore>().eq(TechnicianScore::getTechnicianId, technicianId));
        if (ListUtil.isNotEmpty(list)) {
            List<SkillSku> skillSkuList = skillSkuMapper.selectBatchIds(list.stream().map(TechnicianScore::getSkillSkuId).collect(Collectors.toList()));
            list.forEach(technicianScore -> technicianScore.setSkillSku(skillSkuList.stream().filter(skillSku -> skillSku.getId().equals(technicianScore.getSkillSkuId())).findAny().orElse(null)));
        }
        return JsonResult.success(list);
    }

}
