# gogirl小程序后端

## 如何使用

swagger: http://134.175.167.230:5555/doc.html

## 项目结构

```

└── com
    └── gogirl
        ├── GogirlMiniappApplication.java
        ├── application
        │   ├── common      //通用服务
        │   ├── customer    //用户服务
        │   ├── dashboard   //店员看板服务
        │   ├── market      //营销服务
        │   ├── order       //订单服务
        │   ├── product     //产品服务
        │   ├── store       //店铺服务
        │   └── user        //用户服务（旧）
        ├── assembler       //转换器
        ├── domain          //实体领域层
        ├── infrastructure  //基础设施层
        │   ├── common      //应用通用组件配置
        │   ├── feign       //三方api调用
        │   ├── mapper      //数据库mapper
        │   ├── schedule    //应用定时任务
        │   └── service     //基础服务
        ├── interfaces      //REST API
        └── shared          //dto
```

## 如何开发

### 代码生成器
test/java/com/gogirl/CodeGenerator

### controller
```java
@Api(tags = "商城收货地址接口")
@RestController
@AllArgsConstructor
public class MallCustomerAddressController {

    private final MallCustomerAddressService mallCustomerAddressService;

    @ApiOperation("新增收货地址")
    @PostMapping("/customer/customerAddress/addMallCustomerAddress")
    public JsonResult<MallCustomerAddress> addMallCustomerAddress(@RequestBody MallCustomerAddress mallCustomerAddress) {
        Integer currentCustomerId = SessionUtils.getCustomerId();
        mallCustomerAddress.setCustomerId(currentCustomerId);
        mallCustomerAddress.setIsDefault(MallCustomerAddress.IS_DEFAULT_FALSE);
        mallCustomerAddressService.addMallCustomerAddress(mallCustomerAddress);
        return JsonResult.success(mallCustomerAddress);
    }
}
```

#### service
```java
public interface MallCustomerAddressService extends IService<MallCustomerAddress> {

    /**
     * 新增收货地址
     *
     * @param mallCustomerAddress 收货地址
     */
    void addMallCustomerAddress(MallCustomerAddress mallCustomerAddress);
}

@Service
public class MallCustomerAddressServiceImpl extends ServiceImpl<MallCustomerAddressMapper, MallCustomerAddress> implements MallCustomerAddressService {

    @Override
    public void addMallCustomerAddress(MallCustomerAddress mallCustomerAddress) {
        this.save(mallCustomerAddress);
    }
}
```

#### mapper
```java
public interface MallCustomerAddressMapper extends BaseMapper<MallCustomerAddress> {
}

```

### 发布
1.提交代码
```
git commit push
``` 

2.登陆发布服务器
```
ssh root@http://134.175.167.230/
```

3.发布测试环境
```
sh /deploy-miniapp-pre.sh
``` 
> 注意修改测试分支

4.发布正式环境
```
sh /deploy-miniapp-prod.sh
```
